/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus;

import java.util.Comparator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class DefaultBusPathMatcher
implements PathMatcher {
    private static final Log log = LogFactory.getLog(DefaultBusPathMatcher.class);
    private final PathMatcher delagateMatcher;

    public DefaultBusPathMatcher(PathMatcher delagateMatcher) {
        this.delagateMatcher = delagateMatcher;
    }

    protected boolean matchMultiProfile(String pattern, String idToMatch) {
        String[] tokens;
        if (log.isDebugEnabled()) {
            log.debug((Object)("matchMultiProfile : " + pattern + ", " + idToMatch));
        }
        if ((tokens = StringUtils.tokenizeToStringArray((String)idToMatch, (String)":")).length <= 1) {
            return false;
        }
        String selfProfiles = tokens[1];
        String[] profiles = StringUtils.tokenizeToStringArray((String)selfProfiles, (String)",");
        if (profiles.length == 1) {
            return false;
        }
        String[] idsWithSingleProfile = new String[profiles.length];
        for (int i = 0; i < profiles.length; ++i) {
            String profile = profiles[i];
            Object[] newTokens = new String[tokens.length];
            System.arraycopy(tokens, 0, newTokens, 0, tokens.length);
            newTokens[1] = profile;
            idsWithSingleProfile[i] = StringUtils.arrayToDelimitedString((Object[])newTokens, (String)":");
        }
        for (String id : idsWithSingleProfile) {
            if (!this.delagateMatcher.match(pattern, id)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"matched true");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"matched false");
        }
        return false;
    }

    public boolean isPattern(String path) {
        return this.delagateMatcher.isPattern(path);
    }

    public boolean match(String pattern, String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("In match: " + pattern + ", " + path));
        }
        if (!this.delagateMatcher.match(pattern, path)) {
            return this.matchMultiProfile(pattern, path);
        }
        return true;
    }

    public boolean matchStart(String pattern, String path) {
        return this.delagateMatcher.matchStart(pattern, path);
    }

    public String extractPathWithinPattern(String pattern, String path) {
        return this.delagateMatcher.extractPathWithinPattern(pattern, path);
    }

    public Map<String, String> extractUriTemplateVariables(String pattern, String path) {
        return this.delagateMatcher.extractUriTemplateVariables(pattern, path);
    }

    public Comparator<String> getPatternComparator(String path) {
        return this.delagateMatcher.getPatternComparator(path);
    }

    public String combine(String pattern1, String pattern2) {
        return this.delagateMatcher.combine(pattern1, pattern2);
    }
}

