/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.wiremock;

import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.verifier.util.MetadataUtil;
import org.springframework.cloud.contract.verifier.util.SpringCloudContractMetadata;

public class WireMockMetaData
implements SpringCloudContractMetadata {
    public static final String METADATA_KEY = "wiremock";
    static final List<Class> APPLICABLE_CLASSES = Arrays.asList(String.class, StubMapping.class, Map.class);
    private Object stubMapping;

    public Object getStubMapping() {
        return this.stubMapping;
    }

    public void setStubMapping(Object stubMapping) {
        this.stubMapping = stubMapping;
    }

    public static WireMockMetaData fromMetadata(Map<String, Object> metadata) {
        return (WireMockMetaData)MetadataUtil.fromMetadata(metadata, (String)METADATA_KEY, (Object)new WireMockMetaData());
    }

    public String key() {
        return METADATA_KEY;
    }

    public String description() {
        return "Metadata for extending WireMock stubs.\n\nStubMapping can be one of the following classes " + APPLICABLE_CLASSES.stream().map(aClass -> "`" + aClass.getSimpleName() + "`").collect(Collectors.toList()) + ". Please check the http://wiremock.org/docs/stubbing/ for more information about the StubMapping class properties.";
    }

    public List<Class> additionalClassesToLookAt() {
        return Collections.singletonList(StubMapping.class);
    }
}

