/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.HttpServerStubConfigurer;
import org.springframework.cloud.contract.stubrunner.ResourceResolver;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptionsBuilder;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class StubRunnerOptions {
    private static final Log log = LogFactory.getLog(StubRunnerOptions.class);
    final Integer minPortValue;
    final Integer maxPortValue;
    final Resource stubRepositoryRoot;
    final String stubsClassifier;
    final Collection<StubConfiguration> dependencies;
    final Map<StubConfiguration, Integer> stubIdsToPortMapping;
    final String username;
    final String password;
    final StubRunnerProperties.StubsMode stubsMode;
    private final StubRunnerProxyOptions stubRunnerProxyOptions;
    private final Class<? extends HttpServerStubConfigurer> httpServerStubConfigurer;
    private boolean stubsPerConsumer = false;
    private String consumerName;
    private String mappingsOutputFolder;
    private boolean deleteStubsAfterTest;
    private boolean generateStubs;
    private boolean failOnNoStubs = true;
    private Map<String, String> properties;
    final String serverId;

    StubRunnerOptions(Integer minPortValue, Integer maxPortValue, Resource stubRepositoryRoot, StubRunnerProperties.StubsMode stubsMode, String stubsClassifier, Collection<StubConfiguration> dependencies, Map<StubConfiguration, Integer> stubIdsToPortMapping, String username, String password, StubRunnerProxyOptions stubRunnerProxyOptions, boolean stubsPerConsumer, String consumerName, String mappingsOutputFolder, boolean deleteStubsAfterTest, boolean generateStubs, boolean failOnNoStubs, Map<String, String> properties, Class<? extends HttpServerStubConfigurer> httpServerStubConfigurer, String serverId) {
        this.minPortValue = minPortValue;
        this.maxPortValue = maxPortValue;
        this.stubRepositoryRoot = stubRepositoryRoot;
        this.stubsMode = stubsMode != null ? stubsMode : StubRunnerProperties.StubsMode.CLASSPATH;
        this.stubsClassifier = stubsClassifier;
        this.dependencies = dependencies;
        this.stubIdsToPortMapping = stubIdsToPortMapping;
        this.username = username;
        this.password = password;
        this.stubRunnerProxyOptions = stubRunnerProxyOptions;
        this.stubsPerConsumer = stubsPerConsumer;
        this.consumerName = consumerName;
        this.mappingsOutputFolder = mappingsOutputFolder;
        this.deleteStubsAfterTest = deleteStubsAfterTest;
        this.generateStubs = generateStubs;
        this.failOnNoStubs = failOnNoStubs;
        this.properties = properties;
        this.httpServerStubConfigurer = httpServerStubConfigurer;
        this.serverId = serverId;
    }

    public static StubRunnerOptions fromSystemProps() {
        StubRunnerOptionsBuilder builder = new StubRunnerOptionsBuilder().withMinPort(Integer.valueOf(System.getProperty("stubrunner.port.range.min", "10000"))).withMaxPort(Integer.valueOf(System.getProperty("stubrunner.port.range.max", "15000"))).withStubRepositoryRoot(ResourceResolver.resource(System.getProperty("stubrunner.repository.root", ""))).withStubsMode(System.getProperty("stubrunner.stubs-mode", "LOCAL")).withStubsClassifier(System.getProperty("stubrunner.classifier", "stubs")).withStubs(System.getProperty("stubrunner.ids", "")).withUsername(System.getProperty("stubrunner.username")).withPassword(System.getProperty("stubrunner.password")).withStubPerConsumer(Boolean.parseBoolean(System.getProperty("stubrunner.stubs-per-consumer", "false"))).withConsumerName(System.getProperty("stubrunner.consumer-name")).withMappingsOutputFolder(System.getProperty("stubrunner.mappings-output-folder")).withDeleteStubsAfterTest(Boolean.parseBoolean(System.getProperty("stubrunner.delete-stubs-after-test", "true"))).withGenerateStubs(Boolean.parseBoolean(System.getProperty("stubrunner.generate-stubs", "false"))).withFailOnNoStubs(Boolean.parseBoolean(System.getProperty("stubrunner.fail-on-no-stubs", "false"))).withProperties(StubRunnerOptions.stubRunnerProps()).withServerId(System.getProperty("stubrunner.server-id", ""));
        builder = StubRunnerOptions.httpStubConfigurer(builder);
        String proxyHost = System.getProperty("stubrunner.proxy.host");
        if (proxyHost != null) {
            builder.withProxy(proxyHost, Integer.parseInt(System.getProperty("stubrunner.proxy.port")));
        }
        return builder.build();
    }

    private static StubRunnerOptionsBuilder httpStubConfigurer(StubRunnerOptionsBuilder builder) {
        String classProperty = System.getProperty("stubrunner.http-server-stub-configurer", HttpServerStubConfigurer.NoOpHttpServerStubConfigurer.class.getName());
        try {
            Class<?> clazz = Class.forName(classProperty);
            return builder.withHttpServerStubConfigurer(clazz);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Class [" + classProperty + "] not found", ex);
        }
    }

    private static Map<String, String> stubRunnerProps() {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties properties = System.getProperties();
        Set<String> propertyNames = properties.stringPropertyNames();
        propertyNames.stream().filter(s -> s.toLowerCase().startsWith("stubrunner.properties")).forEach(s -> map.put(s.substring("stubrunner.properties".length() + 1), System.getProperty(s)));
        return map;
    }

    public Integer port(StubConfiguration stubConfiguration) {
        if (this.stubIdsToPortMapping != null) {
            return this.stubIdsToPortMapping.get(stubConfiguration);
        }
        return null;
    }

    public Integer getMinPortValue() {
        return this.minPortValue;
    }

    public Integer getMaxPortValue() {
        return this.maxPortValue;
    }

    public Collection<StubConfiguration> getDependencies() {
        return this.dependencies;
    }

    public Map<StubConfiguration, Integer> getStubIdsToPortMapping() {
        return this.stubIdsToPortMapping;
    }

    public Resource getStubRepositoryRoot() {
        return this.stubRepositoryRoot;
    }

    public String getStubRepositoryRootAsString() {
        if (this.stubRepositoryRoot == null) {
            return "";
        }
        try {
            return this.stubRepositoryRoot.getURI().toString();
        }
        catch (FileNotFoundException f) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"File not found", (Throwable)f);
            }
            return "";
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public StubRunnerProperties.StubsMode getStubsMode() {
        return this.stubsMode;
    }

    public String getStubsClassifier() {
        return this.stubsClassifier;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public StubRunnerProxyOptions getStubRunnerProxyOptions() {
        return this.stubRunnerProxyOptions;
    }

    public StubRunnerProxyOptions getProxyOptions() {
        return this.stubRunnerProxyOptions;
    }

    public boolean isStubsPerConsumer() {
        return this.stubsPerConsumer;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public boolean hasMappingsOutputFolder() {
        return StringUtils.hasText((String)this.mappingsOutputFolder);
    }

    public String getMappingsOutputFolder() {
        return this.mappingsOutputFolder;
    }

    public boolean isDeleteStubsAfterTest() {
        return this.deleteStubsAfterTest;
    }

    public boolean isGenerateStubs() {
        return this.generateStubs;
    }

    public boolean isFailOnNoStubs() {
        return this.failOnNoStubs;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getServerId() {
        return this.serverId;
    }

    public Class<? extends HttpServerStubConfigurer> getHttpServerStubConfigurer() {
        return this.httpServerStubConfigurer;
    }

    public String toString() {
        return "StubRunnerOptions{minPortValue=" + this.minPortValue + ", maxPortValue=" + this.maxPortValue + ", stubRepositoryRoot='" + this.stubRepositoryRoot + '\'' + ", stubsMode='" + (Object)((Object)this.stubsMode) + "', stubsClassifier='" + this.stubsClassifier + '\'' + ", dependencies=" + this.dependencies + ", stubIdsToPortMapping=" + this.stubIdsToPortMapping + ", username='" + this.obfuscate(this.username) + '\'' + ", password='" + this.obfuscate(this.password) + '\'' + ", stubRunnerProxyOptions='" + this.stubRunnerProxyOptions + "', stubsPerConsumer='" + this.stubsPerConsumer + '\'' + ", httpServerStubConfigurer='" + this.httpServerStubConfigurer + '\'' + ", serverId='" + this.serverId + '\'' + '}';
    }

    private String obfuscate(String string) {
        return StringUtils.hasText((String)string) ? "****" : "";
    }

    public static class StubRunnerProxyOptions {
        private final String proxyHost;
        private final int proxyPort;

        public StubRunnerProxyOptions(String proxyHost, int proxyPort) {
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        public String toString() {
            return "StubRunnerProxyOptions{proxyHost='" + this.proxyHost + '\'' + ", proxyPort=" + this.proxyPort + '}';
        }
    }
}

