/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.contract.stubrunner.RepoRoot;
import org.springframework.cloud.contract.stubrunner.RepoRoots;
import org.springframework.cloud.contract.stubrunner.ResourceResolvingStubDownloader;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import shaded.com.google.common.base.Function;

public class ClasspathStubProvider
implements StubDownloaderBuilder {
    private static final Log log = LogFactory.getLog(ClasspathStubProvider.class);

    @Override
    public StubDownloader build(StubRunnerOptions stubRunnerOptions) {
        if (stubRunnerOptions.stubsMode != StubRunnerProperties.StubsMode.CLASSPATH) {
            return null;
        }
        log.info((Object)"Will download stubs from classpath");
        return new ResourceResolvingStubDownloader(stubRunnerOptions, this::repoRoot, (Function<StubConfiguration, Pattern>)((Function)this::gavPattern));
    }

    private RepoRoots repoRoot(StubRunnerOptions stubRunnerOptions, StubConfiguration configuration) {
        ClassPathResource classPathResource;
        String path;
        Resource repositoryRoot = stubRunnerOptions.getStubRepositoryRoot();
        if (repositoryRoot instanceof ClassPathResource && StringUtils.hasText((String)(path = (classPathResource = (ClassPathResource)repositoryRoot).getPath()))) {
            return RepoRoots.asList(new RepoRoot(stubRunnerOptions.getStubRepositoryRootAsString()));
        }
        String path2 = "/**/" + configuration.getGroupId() + "/" + configuration.getArtifactId();
        return RepoRoots.asList(new RepoRoot("classpath*:/META-INF" + path2, "/**/*.*"), new RepoRoot("classpath*:/contracts" + path2, "/**/*.*"), new RepoRoot("classpath*:/mappings" + path2, "/**/*.*"));
    }

    private Pattern gavPattern(StubConfiguration config) {
        String ga = config.getGroupId() + "." + config.getArtifactId();
        return Pattern.compile("^(.*)(" + ga + ")(.*)$");
    }
}

