/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.jms;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.spec.internal.FromFileProperty;
import org.springframework.cloud.contract.stubrunner.messaging.jms.StubRunnerJmsMessageSelector;
import org.springframework.cloud.contract.verifier.util.BodyExtractor;

class StubRunnerJmsTransformer {
    private final StubRunnerJmsMessageSelector selector;

    StubRunnerJmsTransformer(List<Contract> groovyDsls) {
        this.selector = new StubRunnerJmsMessageSelector(groovyDsls);
    }

    public Message transform(Session session, Contract groovyDsl) {
        Object outputBody = this.outputBody(groovyDsl);
        Map headers = groovyDsl.getOutputMessage().getHeaders().asStubSideMap();
        Message newMessage = this.createMessage(session, outputBody);
        this.setHeaders(newMessage, headers);
        this.selector.updateCache(newMessage, groovyDsl);
        return newMessage;
    }

    private Object outputBody(Contract groovyDsl) {
        Object outputBody = BodyExtractor.extractClientValueFromBody((Object)groovyDsl.getOutputMessage().getBody());
        if (outputBody instanceof FromFileProperty) {
            FromFileProperty property = (FromFileProperty)outputBody;
            return property.asBytes();
        }
        return BodyExtractor.extractStubValueFrom((Object)outputBody);
    }

    Contract matchingContract(Message source) {
        return this.selector.matchingContract(source);
    }

    private Message createMessage(Session session, Object payload) {
        try {
            if (payload instanceof String) {
                return session.createTextMessage((String)payload);
            }
            if (payload instanceof byte[]) {
                BytesMessage bytesMessage = session.createBytesMessage();
                bytesMessage.writeBytes((byte[])payload);
                return bytesMessage;
            }
            if (payload instanceof Serializable) {
                return session.createObjectMessage((Serializable)payload);
            }
            return session.createMessage();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void setHeaders(Message message, Map<String, Object> headers) {
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            try {
                if (value instanceof String) {
                    message.setStringProperty(key, (String)value);
                    continue;
                }
                if (value instanceof Boolean) {
                    message.setBooleanProperty(key, ((Boolean)value).booleanValue());
                    continue;
                }
                message.setObjectProperty(key, value);
            }
            catch (JMSException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

