/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.util.Collections;
import java.util.List;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubDownloaderBuilder;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.StubsResource;
import org.springframework.cloud.contract.stubrunner.StubsStubDownloader;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class FileStubDownloader
implements StubDownloaderBuilder {
    private static final List<String> ACCEPTABLE_PROTOCOLS = Collections.singletonList("stubs");

    public static boolean isProtocolAccepted(String url) {
        return ACCEPTABLE_PROTOCOLS.stream().anyMatch(url::startsWith);
    }

    @Override
    public StubDownloader build(StubRunnerOptions stubRunnerOptions) {
        if (stubRunnerOptions.getStubsMode() == StubRunnerProperties.StubsMode.CLASSPATH || stubRunnerOptions.getStubRepositoryRoot() == null) {
            return null;
        }
        Resource resource = stubRunnerOptions.getStubRepositoryRoot();
        if (!(resource instanceof StubsResource)) {
            return null;
        }
        return new StubsStubDownloader(stubRunnerOptions);
    }

    @Override
    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (!StringUtils.hasText((String)location) || !FileStubDownloader.isProtocolAccepted(location)) {
            return null;
        }
        if (!location.startsWith("stubs://file://")) {
            return new StubsResource(location);
        }
        String correctlyFormattedLocation = this.convertLocationToUriFormat(location);
        return new StubsResource(correctlyFormattedLocation);
    }

    private String convertLocationToUriFormat(String location) {
        String correctlyFormattedLocation = this.separatorsToUnix(location);
        String rawPath = correctlyFormattedLocation.replace("stubs://file://", "");
        if (rawPath.charAt(0) != '/') {
            return "stubs://file:///" + rawPath;
        }
        return correctlyFormattedLocation;
    }

    private String separatorsToUnix(String location) {
        return location != null && location.indexOf(92) != -1 ? location.replace('\\', '/') : location;
    }
}

