/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.camel;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.BatchStubRunner;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.messaging.camel.StubRunnerCamelPredicate;
import org.springframework.cloud.contract.stubrunner.messaging.camel.StubRunnerCamelProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RoutesBuilder.class})
@ConditionalOnProperty(name={"stubrunner.camel.enabled"}, havingValue="true", matchIfMissing=true)
public class StubRunnerCamelConfiguration {
    static final String STUBRUNNER_DESTINATION_URL_HEADER_NAME = "STUBRUNNER_DESTINATION_URL";

    @Bean
    public RoutesBuilder myRouter(final BatchStubRunner batchStubRunner) {
        return new RouteBuilder(){

            public void configure() throws Exception {
                Map<StubConfiguration, Collection<Contract>> contracts = batchStubRunner.getContracts();
                for (Map.Entry<StubConfiguration, Collection<Contract>> entry : contracts.entrySet()) {
                    Collection<Contract> value = entry.getValue();
                    LinkedMultiValueMap map = new LinkedMultiValueMap();
                    for (Contract dsl : value) {
                        if (dsl == null || dsl.getInput() == null || dsl.getInput().getMessageFrom() == null || !StringUtils.hasText((String)((String)dsl.getInput().getMessageFrom().getClientValue()))) continue;
                        String from = (String)dsl.getInput().getMessageFrom().getClientValue();
                        map.add((Object)from, (Object)dsl);
                    }
                    for (Map.Entry entries : map.entrySet()) {
                        ((ExpressionNode)this.from((String)entries.getKey()).filter((Predicate)new StubRunnerCamelPredicate((List)entries.getValue())).process((Processor)new StubRunnerCamelProcessor())).dynamicRouter((Expression)this.header(StubRunnerCamelConfiguration.STUBRUNNER_DESTINATION_URL_HEADER_NAME));
                    }
                }
            }
        };
    }

    @Bean
    DummyProcessor dummyStubRunnerProcessor() {
        return new DummyProcessor();
    }

    private static class DummyProcessor
    implements Processor {
        private static final Log log = LogFactory.getLog(DummyProcessor.class);

        private DummyProcessor() {
        }

        public void process(Exchange exchange) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Got exchange [" + exchange + "]"));
            }
        }
    }
}

