/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.jms;

import java.util.List;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.messaging.jms.StubRunnerJmsMessageSelector;
import org.springframework.cloud.contract.stubrunner.messaging.jms.StubRunnerJmsTransformer;
import org.springframework.jms.core.JmsTemplate;

class StubRunnerJmsRouter
implements MessageListener {
    private final StubRunnerJmsMessageSelector selector;
    private final BeanFactory beanFactory;
    private final List<Contract> contracts;
    private JmsTemplate jmsTemplate;

    StubRunnerJmsRouter(List<Contract> groovyDsls, BeanFactory beanFactory) {
        this.selector = new StubRunnerJmsMessageSelector(groovyDsls);
        this.beanFactory = beanFactory;
        this.contracts = groovyDsls;
    }

    public void onMessage(Message message) {
        Contract dsl = this.selector.matchingContract(message);
        if (dsl != null && dsl.getOutputMessage() != null && dsl.getOutputMessage().getSentTo() != null) {
            String destination = (String)dsl.getOutputMessage().getSentTo().getClientValue();
            this.jmsTemplate().send(destination, session -> new StubRunnerJmsTransformer(this.contracts).transform(session, dsl));
        }
    }

    private JmsTemplate jmsTemplate() {
        if (this.jmsTemplate == null) {
            this.jmsTemplate = (JmsTemplate)this.beanFactory.getBean(JmsTemplate.class);
        }
        return this.jmsTemplate;
    }
}

