/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.cloud.contract.verifier.builder.Acceptor;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.ClassAnnotation;
import org.springframework.cloud.contract.verifier.builder.ClassAnnotationsBuilder;
import org.springframework.cloud.contract.verifier.builder.ClassBodyBuilder;
import org.springframework.cloud.contract.verifier.builder.ClassMetaData;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.builder.GeneratedTestClass;
import org.springframework.cloud.contract.verifier.builder.Imports;
import org.springframework.cloud.contract.verifier.builder.ImportsBuilder;
import org.springframework.cloud.contract.verifier.builder.MetaDataBuilder;
import org.springframework.cloud.contract.verifier.builder.OurCallable;
import org.springframework.cloud.contract.verifier.builder.Visitor;

class GeneratedTestClassBuilder {
    private List<ClassMetaData> metaData = new LinkedList<ClassMetaData>();
    private List<Imports> imports = new LinkedList<Imports>();
    private List<Imports> staticImports = new LinkedList<Imports>();
    private List<ClassAnnotation> annotations = new LinkedList<ClassAnnotation>();
    private ClassBodyBuilder classBodyBuilder;
    final BlockBuilder blockBuilder;
    final GeneratedClassMetaData generatedClassMetaData;

    private GeneratedTestClassBuilder(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    static GeneratedTestClassBuilder builder(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        return new GeneratedTestClassBuilder(blockBuilder, generatedClassMetaData);
    }

    GeneratedTestClassBuilder metaData(ClassMetaData metaData) {
        this.metaData.add(metaData);
        return this;
    }

    MetaDataBuilder metaData() {
        return new MetaDataBuilder(this);
    }

    GeneratedTestClassBuilder metaData(ClassMetaData ... metaData) {
        return this.metaData(Arrays.asList(metaData));
    }

    GeneratedTestClassBuilder metaData(List<ClassMetaData> metaData) {
        this.metaData.addAll(metaData);
        return this;
    }

    ImportsBuilder imports() {
        return new ImportsBuilder(this);
    }

    GeneratedTestClassBuilder imports(Imports imports) {
        this.imports.add(imports);
        return this;
    }

    GeneratedTestClassBuilder imports(Imports ... imports) {
        return this.imports(Arrays.asList(imports));
    }

    GeneratedTestClassBuilder imports(List<Imports> imports) {
        this.imports.addAll(imports);
        return this;
    }

    GeneratedTestClassBuilder staticImports(Imports imports) {
        this.staticImports.add(imports);
        return this;
    }

    GeneratedTestClassBuilder staticImports(Imports ... imports) {
        return this.staticImports(Arrays.asList(imports));
    }

    GeneratedTestClassBuilder staticImports(List<Imports> imports) {
        this.staticImports.addAll(imports);
        return this;
    }

    ClassAnnotationsBuilder classAnnotations() {
        return new ClassAnnotationsBuilder(this);
    }

    GeneratedTestClassBuilder classAnnotations(ClassAnnotation ... annotations) {
        List<ClassAnnotation> classAnnotations = Arrays.asList(annotations);
        this.annotations.addAll(classAnnotations);
        return this;
    }

    GeneratedTestClassBuilder classBodyBuilder(ClassBodyBuilder classBodyBuilder) {
        this.classBodyBuilder = classBodyBuilder;
        return this;
    }

    GeneratedTestClass build() {
        ClassMetaData classMetaData = this.metaData.stream().filter(Acceptor::accept).findFirst().orElseThrow(() -> new IllegalStateException("There is no matching class meta data"));
        classMetaData.setupLineEnding().setupLabelPrefix().packageDefinition();
        this.blockBuilder.addEmptyLine();
        this.visitSeparated(this.imports);
        this.visitSeparated(this.staticImports);
        this.visitWithNoEnding(this.annotations);
        this.blockBuilder.append(classMetaData::modifier).addAtTheEndIfEndsWithAChar(" ").append("class").appendWithSpace(classMetaData::className).append(classMetaData::suffix).appendWithSpace(classMetaData::parentClass);
        this.classBodyBuilder.build();
        return new GeneratedTestClass(this.blockBuilder);
    }

    void visitSeparated(List<? extends Visitor> list) {
        this.visit(list, true, true);
    }

    void visitWithNoEnding(List<? extends Visitor> list) {
        this.visit(list, false, false);
    }

    private void visit(List<? extends Visitor> list, boolean addEnding, boolean separated) {
        List<Visitor> elements = list.stream().filter(Acceptor::accept).collect(Collectors.toList());
        elements.forEach(OurCallable::call);
        if (addEnding) {
            this.blockBuilder.addEndingIfNotPresent();
        }
        if (!elements.isEmpty() && separated) {
            this.blockBuilder.addEmptyLine();
        }
    }
}

