/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.filter.HttpHeadersFilter;
import org.springframework.cloud.gateway.server.mvc.filter.TrustedProxies;
import org.springframework.cloud.gateway.server.mvc.filter.XForwardedRequestHeadersFilterProperties;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogMessage;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.function.ServerRequest;

public class XForwardedRequestHeadersFilter
implements HttpHeadersFilter.RequestHttpHeadersFilter,
Ordered {
    private static final Log log = LogFactory.getLog(XForwardedRequestHeadersFilter.class);
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    public static final String X_FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    public static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";
    public static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    public static final String X_FORWARDED_PREFIX_HEADER = "X-Forwarded-Prefix";
    private final XForwardedRequestHeadersFilterProperties properties;
    private final TrustedProxies trustedProxies;

    @Deprecated
    public XForwardedRequestHeadersFilter(XForwardedRequestHeadersFilterProperties properties) {
        this(properties, (String s) -> true);
        log.warn((Object)"spring.cloud.gateway.server.webmvc.trusted-proxies is not set. Using deprecated Constructor. Untrusted hosts might be added to X-Forwarded header.");
    }

    public XForwardedRequestHeadersFilter(XForwardedRequestHeadersFilterProperties props, String trustedProxies) {
        this(props, TrustedProxies.from(trustedProxies));
    }

    private XForwardedRequestHeadersFilter(XForwardedRequestHeadersFilterProperties props, TrustedProxies trustedProxies) {
        Assert.notNull((Object)props, (String)"XForwardedRequestHeadersFilterProperties must not be null");
        Assert.notNull((Object)trustedProxies, (String)"trustedProxies must not be null");
        this.properties = props;
        this.trustedProxies = trustedProxies;
    }

    public int getOrder() {
        return this.properties.getOrder();
    }

    @Override
    public HttpHeaders apply(HttpHeaders input, ServerRequest request) {
        if (request.servletRequest().getRemoteAddr() != null && !this.trustedProxies.isTrusted(request.servletRequest().getRemoteAddr())) {
            log.trace((Object)LogMessage.format((String)"Remote address not trusted. pattern %s remote address %s", (Object)this.trustedProxies, (Object)request.servletRequest().getRemoteHost()));
            return input;
        }
        HttpHeaders original = input;
        HttpHeaders updated = new HttpHeaders();
        for (Map.Entry entry : original.headerSet()) {
            updated.addAll((String)entry.getKey(), (List)entry.getValue());
        }
        if (this.properties.isForEnabled()) {
            String remoteAddr = null;
            if (request.servletRequest().getRemoteAddr() != null) {
                remoteAddr = request.servletRequest().getRemoteAddr();
            }
            this.write(updated, X_FORWARDED_FOR_HEADER, remoteAddr, this.properties.isForAppend(), this.trustedProxies::isTrusted);
        }
        String proto = request.uri().getScheme();
        if (this.properties.isProtoEnabled()) {
            this.write(updated, X_FORWARDED_PROTO_HEADER, proto, this.properties.isProtoAppend());
        }
        if (this.properties.isPrefixEnabled()) {
            LinkedHashSet originalUris = (LinkedHashSet)MvcUtils.getAttribute(request, MvcUtils.GATEWAY_ORIGINAL_REQUEST_URL_ATTR);
            URI requestUri = request.uri();
            if (originalUris != null && requestUri != null) {
                originalUris.forEach(originalUri -> {
                    if (originalUri != null && originalUri.getPath() != null) {
                        String originalUriPath = this.stripTrailingSlash((URI)originalUri);
                        String requestUriPath = this.stripTrailingSlash(requestUri);
                        this.updateRequest(updated, (URI)originalUri, originalUriPath, requestUriPath);
                    }
                });
            }
        }
        if (this.properties.isPortEnabled()) {
            String port = String.valueOf(request.uri().getPort());
            if (request.uri().getPort() < 0) {
                port = String.valueOf(this.getDefaultPort(proto));
            }
            this.write(updated, X_FORWARDED_PORT_HEADER, port, this.properties.isPortAppend());
        }
        if (this.properties.isHostEnabled()) {
            String host = this.toHostHeader(request);
            this.write(updated, X_FORWARDED_HOST_HEADER, host, this.properties.isHostAppend());
        }
        return updated;
    }

    private void updateRequest(HttpHeaders updated, URI originalUri, String originalUriPath, String requestUriPath) {
        String prefix;
        if (requestUriPath != null && originalUriPath.endsWith(requestUriPath) && (prefix = XForwardedRequestHeadersFilter.substringBeforeLast(originalUriPath, requestUriPath)) != null && prefix.length() > 0 && prefix.length() <= originalUri.getPath().length()) {
            this.write(updated, X_FORWARDED_PREFIX_HEADER, prefix, this.properties.isPrefixAppend());
        }
    }

    private static String substringBeforeLast(String str, String separator) {
        if (ObjectUtils.isEmpty((Object)str) || ObjectUtils.isEmpty((Object)separator)) {
            return str;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    private void write(HttpHeaders headers, String name, String value, boolean append) {
        this.write(headers, name, value, append, s -> true);
    }

    private void write(HttpHeaders headers, String name, String value, boolean append, Predicate<String> shouldWrite) {
        if (append) {
            if (value != null) {
                headers.add(name, value);
            }
            if (headers.containsKey((Object)name)) {
                List<String> values = headers.get((Object)name).stream().filter(shouldWrite).toList();
                String delimitedValue = StringUtils.collectionToCommaDelimitedString(values);
                headers.set(name, delimitedValue);
            }
        } else if (value != null && shouldWrite.test(value)) {
            headers.set(name, value);
        }
    }

    private int getDefaultPort(String scheme) {
        return HTTPS_SCHEME.equals(scheme) ? 443 : 80;
    }

    private String toHostHeader(ServerRequest request) {
        int port = request.uri().getPort();
        String host = request.uri().getHost();
        String scheme = request.uri().getScheme();
        if (port < 0 || port == 80 && HTTP_SCHEME.equals(scheme) || port == 443 && HTTPS_SCHEME.equals(scheme)) {
            return host;
        }
        return host + ":" + port;
    }

    private String stripTrailingSlash(URI uri) {
        if (uri.getPath().endsWith("/")) {
            return uri.getPath().substring(0, uri.getPath().length() - 1);
        }
        return uri.getPath();
    }
}

