/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import org.springframework.cloud.gateway.server.mvc.common.AbstractProxyExchange;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.config.GatewayMvcProperties;
import org.springframework.cloud.gateway.server.mvc.handler.ClientHttpResponseAdapter;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayServerResponse;
import org.springframework.cloud.gateway.server.mvc.handler.ProxyExchange;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;
import org.springframework.web.servlet.function.ServerResponse;

public class ClientHttpRequestFactoryProxyExchange
extends AbstractProxyExchange {
    private final ClientHttpRequestFactory requestFactory;

    @Deprecated
    public ClientHttpRequestFactoryProxyExchange(ClientHttpRequestFactory requestFactory) {
        super(new GatewayMvcProperties());
        this.requestFactory = requestFactory;
    }

    public ClientHttpRequestFactoryProxyExchange(ClientHttpRequestFactory requestFactory, GatewayMvcProperties properties) {
        super(properties);
        this.requestFactory = requestFactory;
    }

    @Override
    public ServerResponse exchange(ProxyExchange.Request request) {
        try {
            ClientHttpRequest clientHttpRequest = this.requestFactory.createRequest(request.getUri(), request.getMethod());
            clientHttpRequest.getHeaders().putAll((Map)request.getHeaders());
            StreamUtils.copy((InputStream)request.getServerRequest().servletRequest().getInputStream(), (OutputStream)clientHttpRequest.getBody());
            ClientHttpResponse clientHttpResponse = clientHttpRequest.execute();
            InputStream body = clientHttpResponse.getBody();
            MvcUtils.putAttribute(request.getServerRequest(), MvcUtils.CLIENT_RESPONSE_INPUT_STREAM_ATTR, body);
            MvcUtils.putAttribute(request.getServerRequest(), MvcUtils.CLIENT_RESPONSE_ATTR, clientHttpResponse);
            ServerResponse serverResponse = GatewayServerResponse.status(clientHttpResponse.getStatusCode()).build((req, httpServletResponse) -> {
                try (ClientHttpResponse clientHttpResponse2 = clientHttpResponse;){
                    InputStream inputStream = (InputStream)MvcUtils.getAttribute(request.getServerRequest(), MvcUtils.CLIENT_RESPONSE_INPUT_STREAM_ATTR);
                    this.copyResponseBody(clientHttpResponse, inputStream, (OutputStream)httpServletResponse.getOutputStream());
                }
                return null;
            });
            ClientHttpResponseAdapter proxyExchangeResponse = new ClientHttpResponseAdapter(clientHttpResponse);
            request.getResponseConsumers().forEach(responseConsumer -> responseConsumer.accept(proxyExchangeResponse, serverResponse));
            return serverResponse;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

