/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Weigher;
import java.time.Duration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.cloud.gateway.filter.factory.cache.LocalResponseCacheProperties;
import org.springframework.cloud.gateway.filter.factory.cache.ResponseCacheSizeWeigher;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;

public final class LocalResponseCacheUtils {
    private static final Log LOGGER = LogFactory.getLog(LocalResponseCacheUtils.class);

    private LocalResponseCacheUtils() {
    }

    public static boolean isNoCacheRequest(ServerHttpRequest request) {
        String cacheControl = request.getHeaders().getCacheControl();
        return StringUtils.hasText((String)cacheControl) && cacheControl.matches(".*( |,|^)no-cache(\\s|,|$).*");
    }

    public static CaffeineCacheManager createGatewayCacheManager(LocalResponseCacheProperties cacheProperties) {
        Caffeine caffeine = LocalResponseCacheUtils.createCaffeine(cacheProperties);
        CaffeineCacheManager caffeineCacheManager = new CaffeineCacheManager();
        caffeineCacheManager.setCaffeine(caffeine);
        return caffeineCacheManager;
    }

    public static Caffeine createCaffeine(LocalResponseCacheProperties cacheProperties) {
        Caffeine caffeine = Caffeine.newBuilder();
        LOGGER.info((Object)"Initializing Caffeine");
        Duration ttlSeconds = cacheProperties.getTimeToLive();
        caffeine.expireAfterWrite(ttlSeconds);
        if (cacheProperties.getSize() != null) {
            caffeine.maximumWeight(cacheProperties.getSize().toBytes()).weigher((Weigher)new ResponseCacheSizeWeigher());
        }
        return caffeine;
    }
}

