/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery;

import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.util.generic.GenericKubernetesApi;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.kubernetes.client.KubernetesClientAutoConfiguration;
import org.springframework.cloud.kubernetes.client.KubernetesClientUtils;
import org.springframework.cloud.kubernetes.client.discovery.KubernetesInformerDiscoveryClient;
import org.springframework.cloud.kubernetes.commons.KubernetesClientProperties;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigServerBootstrapper;
import org.springframework.cloud.kubernetes.commons.config.KubernetesConfigServerInstanceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;

class KubernetesClientConfigServerBootstrapper
extends KubernetesConfigServerBootstrapper {
    KubernetesClientConfigServerBootstrapper() {
    }

    public void initialize(BootstrapRegistry registry) {
        if (KubernetesClientConfigServerBootstrapper.hasConfigServerInstanceProvider()) {
            return;
        }
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, KubernetesFunction::create);
    }

    static final class KubernetesFunction
    implements ConfigServerInstanceProvider.Function {
        private final BootstrapContext context;

        private KubernetesFunction(BootstrapContext context) {
            this.context = context;
        }

        static KubernetesFunction create(BootstrapContext context) {
            return new KubernetesFunction(context);
        }

        public List<ServiceInstance> apply(String serviceId, Binder binder, BindHandler bindHandler, Log log) {
            if (binder == null || bindHandler == null || !KubernetesConfigServerBootstrapper.getDiscoveryEnabled((Binder)binder, (BindHandler)bindHandler).booleanValue()) {
                return Collections.emptyList();
            }
            KubernetesDiscoveryProperties discoveryProperties = KubernetesConfigServerBootstrapper.createKubernetesDiscoveryProperties((Binder)binder, (BindHandler)bindHandler);
            KubernetesClientProperties clientProperties = KubernetesConfigServerBootstrapper.createKubernetesClientProperties((Binder)binder, (BindHandler)bindHandler);
            return this.getInstanceProvider(discoveryProperties, clientProperties, this.context, binder, bindHandler, log).getInstances(serviceId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KubernetesConfigServerInstanceProvider getInstanceProvider(KubernetesDiscoveryProperties discoveryProperties, KubernetesClientProperties clientProperties, BootstrapContext context, Binder binder, BindHandler bindHandler, Log log) {
            if (context.isRegistered(KubernetesInformerDiscoveryClient.class)) {
                KubernetesInformerDiscoveryClient client = (KubernetesInformerDiscoveryClient)context.get(KubernetesInformerDiscoveryClient.class);
                return client::getInstances;
            }
            ApiClient defaultApiClient = KubernetesClientUtils.kubernetesApiClient();
            defaultApiClient.setUserAgent((String)binder.bind("spring.cloud.kubernetes.client.user-agent", String.class).orElse((Object)"Spring-Cloud-Kubernetes-Application"));
            KubernetesClientAutoConfiguration clientAutoConfiguration = new KubernetesClientAutoConfiguration();
            ApiClient apiClient = (ApiClient)context.getOrElseSupply(ApiClient.class, () -> defaultApiClient);
            KubernetesNamespaceProvider kubernetesNamespaceProvider = clientAutoConfiguration.kubernetesNamespaceProvider(this.getNamespaceEnvironment(binder, bindHandler));
            String namespace = this.getInformerNamespace(kubernetesNamespaceProvider, discoveryProperties);
            SharedInformerFactory sharedInformerFactory = new SharedInformerFactory(apiClient);
            GenericKubernetesApi servicesApi = new GenericKubernetesApi(V1Service.class, V1ServiceList.class, "", "v1", "services", apiClient);
            SharedIndexInformer serviceSharedIndexInformer = sharedInformerFactory.sharedIndexInformerFor(servicesApi, V1Service.class, 0L, namespace);
            Lister serviceLister = new Lister(serviceSharedIndexInformer.getIndexer());
            GenericKubernetesApi endpointsApi = new GenericKubernetesApi(V1Endpoints.class, V1EndpointsList.class, "", "v1", "endpoints", apiClient);
            SharedIndexInformer endpointsSharedIndexInformer = sharedInformerFactory.sharedIndexInformerFor(endpointsApi, V1Endpoints.class, 0L, namespace);
            Lister endpointsLister = new Lister(endpointsSharedIndexInformer.getIndexer());
            KubernetesInformerDiscoveryClient discoveryClient = new KubernetesInformerDiscoveryClient(sharedInformerFactory, (Lister<V1Service>)serviceLister, (Lister<V1Endpoints>)endpointsLister, (SharedInformer<V1Service>)serviceSharedIndexInformer, (SharedInformer<V1Endpoints>)endpointsSharedIndexInformer, discoveryProperties);
            try {
                discoveryClient.afterPropertiesSet();
                KubernetesConfigServerInstanceProvider kubernetesConfigServerInstanceProvider = discoveryClient::getInstances;
                return kubernetesConfigServerInstanceProvider;
            }
            catch (Exception e) {
                if (log != null) {
                    log.warn((Object)"Error initiating informer discovery client", (Throwable)e);
                }
                KubernetesConfigServerInstanceProvider kubernetesConfigServerInstanceProvider = serviceId -> Collections.emptyList();
                return kubernetesConfigServerInstanceProvider;
            }
            finally {
                sharedInformerFactory.stopAllRegisteredInformers();
            }
        }

        private String getInformerNamespace(KubernetesNamespaceProvider kubernetesNamespaceProvider, KubernetesDiscoveryProperties discoveryProperties) {
            return discoveryProperties.allNamespaces() ? "" : (kubernetesNamespaceProvider.getNamespace() == null ? "default" : kubernetesNamespaceProvider.getNamespace());
        }

        private Environment getNamespaceEnvironment(final Binder binder, final BindHandler bindHandler) {
            return new AbstractEnvironment(){

                public String getProperty(String key) {
                    return (String)binder.bind(key, Bindable.of(String.class), bindHandler).orElse((Object)super.getProperty(key));
                }
            };
        }

        public List<ServiceInstance> apply(String serviceId) {
            return this.apply(serviceId, null, null, null);
        }
    }
}

