/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.MultipleSourcesContainer;
import org.springframework.cloud.kubernetes.commons.config.PrefixContext;
import org.springframework.cloud.kubernetes.commons.config.SourceData;

public abstract class NamedSourceData {
    public final SourceData compute(String sourceName, ConfigUtils.Prefix prefix, String target, boolean profileSources, boolean failFast, String namespace, String[] activeProfiles) {
        LinkedHashSet<String> sourceNames = new LinkedHashSet<String>();
        sourceNames.add(sourceName);
        MultipleSourcesContainer data = MultipleSourcesContainer.empty();
        try {
            if (profileSources) {
                for (String activeProfile : activeProfiles) {
                    sourceNames.add(sourceName + "-" + activeProfile);
                }
            }
            if ((data = this.dataSupplier(sourceNames)).names().isEmpty()) {
                return new SourceData(ConfigUtils.sourceName(target, sourceName, namespace), Map.of());
            }
            if (prefix != ConfigUtils.Prefix.DEFAULT) {
                String prefixToUse = prefix.prefixProvider().get();
                PrefixContext prefixContext = new PrefixContext(data.data(), prefixToUse, namespace, data.names());
                return ConfigUtils.withPrefix(target, prefixContext);
            }
        }
        catch (Exception e) {
            ConfigUtils.onException(failFast, e);
        }
        String names = data.names().stream().sorted().collect(Collectors.joining("."));
        return new SourceData(ConfigUtils.sourceName(target, names, namespace), data.data());
    }

    public abstract MultipleSourcesContainer dataSupplier(LinkedHashSet<String> var1);
}

