/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.route;

import com.netflix.client.ClientException;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientFactory;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.cloud.netflix.zuul.util.ZuulRuntimeException;
import org.springframework.context.ApplicationListener;
import org.springframework.http.HttpStatus;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class SimpleHostRoutingFilter
extends ZuulFilter
implements ApplicationListener<EnvironmentChangeEvent> {
    private static final Log log = LogFactory.getLog(SimpleHostRoutingFilter.class);
    private static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("/{2,}");
    private final Timer connectionManagerTimer = new Timer("SimpleHostRoutingFilter.connectionManagerTimer", true);
    private boolean sslHostnameValidationEnabled;
    private boolean forceOriginalQueryStringEncoding;
    private ProxyRequestHelper helper;
    private ZuulProperties.Host hostProperties;
    private ApacheHttpClientConnectionManagerFactory connectionManagerFactory;
    private ApacheHttpClientFactory httpClientFactory;
    private HttpClientConnectionManager connectionManager;
    private CloseableHttpClient httpClient;
    private boolean customHttpClient = false;
    private boolean useServlet31 = true;

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        this.onPropertyChange(event);
    }

    @Deprecated
    public void onPropertyChange(EnvironmentChangeEvent event) {
        if (!this.customHttpClient) {
            boolean createNewClient = false;
            for (String key : event.getKeys()) {
                if (!key.startsWith("zuul.host.")) continue;
                createNewClient = true;
                break;
            }
            if (createNewClient) {
                try {
                    this.httpClient.close();
                }
                catch (IOException ex) {
                    log.error((Object)"error closing client", (Throwable)ex);
                }
                try {
                    this.connectionManager.shutdown();
                }
                catch (RuntimeException ex) {
                    log.error((Object)"error shutting down connection manager", (Throwable)ex);
                }
                this.connectionManager = this.newConnectionManager();
                this.httpClient = this.newClient();
            }
        }
    }

    public SimpleHostRoutingFilter(ProxyRequestHelper helper, ZuulProperties properties, ApacheHttpClientConnectionManagerFactory connectionManagerFactory, ApacheHttpClientFactory httpClientFactory) {
        this.helper = helper;
        this.hostProperties = properties.getHost();
        this.sslHostnameValidationEnabled = properties.isSslHostnameValidationEnabled();
        this.forceOriginalQueryStringEncoding = properties.isForceOriginalQueryStringEncoding();
        this.connectionManagerFactory = connectionManagerFactory;
        this.httpClientFactory = httpClientFactory;
        this.checkServletVersion();
    }

    public SimpleHostRoutingFilter(ProxyRequestHelper helper, ZuulProperties properties, CloseableHttpClient httpClient) {
        this.helper = helper;
        this.hostProperties = properties.getHost();
        this.sslHostnameValidationEnabled = properties.isSslHostnameValidationEnabled();
        this.forceOriginalQueryStringEncoding = properties.isForceOriginalQueryStringEncoding();
        this.httpClient = httpClient;
        this.customHttpClient = true;
        this.checkServletVersion();
    }

    @PostConstruct
    private void initialize() {
        if (!this.customHttpClient) {
            this.connectionManager = this.newConnectionManager();
            this.httpClient = this.newClient();
            this.connectionManagerTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (SimpleHostRoutingFilter.this.connectionManager == null) {
                        return;
                    }
                    SimpleHostRoutingFilter.this.connectionManager.closeExpiredConnections();
                }
            }, 30000L, 5000L);
        }
    }

    @PreDestroy
    public void stop() {
        this.connectionManagerTimer.cancel();
    }

    public String filterType() {
        return "route";
    }

    public int filterOrder() {
        return 100;
    }

    public boolean shouldFilter() {
        return RequestContext.getCurrentContext().getRouteHost() != null && RequestContext.getCurrentContext().sendZuulResponse();
    }

    public Object run() {
        RequestContext context = RequestContext.getCurrentContext();
        HttpServletRequest request = context.getRequest();
        MultiValueMap<String, String> headers = this.helper.buildZuulRequestHeaders(request);
        MultiValueMap<String, String> params = this.helper.buildZuulRequestQueryParams(request);
        String verb = this.getVerb(request);
        InputStream requestEntity = this.getRequestBody(request);
        if (this.getContentLength(request) < 0L) {
            context.setChunkedRequestBody();
        }
        String uri = this.helper.buildZuulRequestURI(request);
        this.helper.addIgnoredHeaders(new String[0]);
        try {
            CloseableHttpResponse response = this.forward(this.httpClient, verb, uri, request, headers, params, requestEntity);
            this.setResponse((HttpResponse)response);
        }
        catch (Exception ex) {
            throw new ZuulRuntimeException(this.handleException(ex));
        }
        return null;
    }

    protected ZuulException handleException(Exception ex) {
        int statusCode = HttpStatus.INTERNAL_SERVER_ERROR.value();
        Exception cause = ex;
        String message = ex.getMessage();
        ClientException clientException = this.findClientException(ex);
        if (clientException != null) {
            if (clientException.getErrorType() == ClientException.ErrorType.SERVER_THROTTLED) {
                statusCode = HttpStatus.SERVICE_UNAVAILABLE.value();
            }
            cause = clientException;
            message = clientException.getErrorType().toString();
        }
        return new ZuulException((Throwable)cause, "Forwarding error", statusCode, message);
    }

    protected ClientException findClientException(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof ClientException) {
            return (ClientException)t;
        }
        return this.findClientException(t.getCause());
    }

    protected void checkServletVersion() {
        try {
            HttpServletRequest.class.getMethod("getContentLengthLong", new Class[0]);
            this.useServlet31 = true;
        }
        catch (NoSuchMethodException e) {
            this.useServlet31 = false;
        }
    }

    protected void setUseServlet31(boolean useServlet31) {
        this.useServlet31 = useServlet31;
    }

    protected HttpClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    protected HttpClientConnectionManager newConnectionManager() {
        return this.connectionManagerFactory.newConnectionManager(!this.sslHostnameValidationEnabled, this.hostProperties.getMaxTotalConnections(), this.hostProperties.getMaxPerRouteConnections(), this.hostProperties.getTimeToLive(), this.hostProperties.getTimeUnit(), null);
    }

    protected CloseableHttpClient newClient() {
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.hostProperties.getConnectionRequestTimeoutMillis()).setSocketTimeout(this.hostProperties.getSocketTimeoutMillis()).setConnectTimeout(this.hostProperties.getConnectTimeoutMillis()).setCookieSpec("ignoreCookies").build();
        return this.httpClientFactory.createBuilder().setDefaultRequestConfig(requestConfig).setConnectionManager(this.connectionManager).disableRedirectHandling().build();
    }

    private CloseableHttpResponse forward(CloseableHttpClient httpclient, String verb, String uri, HttpServletRequest request, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, InputStream requestEntity) throws Exception {
        Map<String, Object> info = this.helper.debug(verb, uri, headers, params, requestEntity);
        URL host = RequestContext.getCurrentContext().getRouteHost();
        HttpHost httpHost = this.getHttpHost(host);
        uri = StringUtils.cleanPath((String)MULTIPLE_SLASH_PATTERN.matcher(host.getPath() + uri).replaceAll("/"));
        long contentLength = this.getContentLength(request);
        ContentType contentType = null;
        if (request.getContentType() != null) {
            contentType = ContentType.parse((String)request.getContentType());
        }
        InputStreamEntity entity = new InputStreamEntity(requestEntity, contentLength, contentType);
        HttpRequest httpRequest = this.buildHttpRequest(verb, uri, entity, headers, params, request);
        log.debug((Object)(httpHost.getHostName() + " " + httpHost.getPort() + " " + httpHost.getSchemeName()));
        CloseableHttpResponse zuulResponse = this.forwardRequest(httpclient, httpHost, httpRequest);
        this.helper.appendDebug(info, zuulResponse.getStatusLine().getStatusCode(), this.revertHeaders(zuulResponse.getAllHeaders()));
        return zuulResponse;
    }

    protected HttpRequest buildHttpRequest(String verb, String uri, InputStreamEntity entity, MultiValueMap<String, String> headers, MultiValueMap<String, String> params, HttpServletRequest request) {
        BasicHttpRequest httpRequest;
        String uriWithQueryString = uri + (this.forceOriginalQueryStringEncoding ? this.getEncodedQueryString(request) : this.helper.getQueryString(params));
        switch (verb.toUpperCase()) {
            case "POST": {
                HttpPost httpPost = new HttpPost(uriWithQueryString);
                httpRequest = httpPost;
                httpPost.setEntity((HttpEntity)entity);
                break;
            }
            case "PUT": {
                HttpPut httpPut = new HttpPut(uriWithQueryString);
                httpRequest = httpPut;
                httpPut.setEntity((HttpEntity)entity);
                break;
            }
            case "PATCH": {
                HttpPatch httpPatch = new HttpPatch(uriWithQueryString);
                httpRequest = httpPatch;
                httpPatch.setEntity((HttpEntity)entity);
                break;
            }
            case "DELETE": {
                BasicHttpEntityEnclosingRequest entityRequest = new BasicHttpEntityEnclosingRequest(verb, uriWithQueryString);
                httpRequest = entityRequest;
                entityRequest.setEntity((HttpEntity)entity);
                break;
            }
            default: {
                httpRequest = new BasicHttpRequest(verb, uriWithQueryString);
                log.debug((Object)uriWithQueryString);
            }
        }
        httpRequest.setHeaders(this.convertHeaders(headers));
        return httpRequest;
    }

    private String getEncodedQueryString(HttpServletRequest request) {
        String query = request.getQueryString();
        return query != null ? "?" + query : "";
    }

    private MultiValueMap<String, String> revertHeaders(Header[] headers) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (Header header : headers) {
            String name = header.getName();
            if (!map.containsKey((Object)name)) {
                map.put((Object)name, new ArrayList());
            }
            ((List)map.get((Object)name)).add(header.getValue());
        }
        return map;
    }

    private Header[] convertHeaders(MultiValueMap<String, String> headers) {
        ArrayList<BasicHeader> list = new ArrayList<BasicHeader>();
        for (String name : headers.keySet()) {
            for (String value : (List)headers.get((Object)name)) {
                list.add(new BasicHeader(name, value));
            }
        }
        return (Header[])list.toArray(new BasicHeader[0]);
    }

    private CloseableHttpResponse forwardRequest(CloseableHttpClient httpclient, HttpHost httpHost, HttpRequest httpRequest) throws IOException {
        return httpclient.execute(httpHost, httpRequest);
    }

    private HttpHost getHttpHost(URL host) {
        HttpHost httpHost = new HttpHost(host.getHost(), host.getPort(), host.getProtocol());
        return httpHost;
    }

    protected InputStream getRequestBody(HttpServletRequest request) {
        InputStream requestEntity = null;
        try {
            requestEntity = (InputStream)RequestContext.getCurrentContext().get((Object)"requestEntity");
            if (requestEntity == null) {
                requestEntity = request.getInputStream();
            }
        }
        catch (IOException ex) {
            log.error((Object)"error during getRequestBody", (Throwable)ex);
        }
        return requestEntity;
    }

    private String getVerb(HttpServletRequest request) {
        String sMethod = request.getMethod();
        return sMethod.toUpperCase();
    }

    private void setResponse(HttpResponse response) throws IOException {
        RequestContext.getCurrentContext().set("zuulResponse", (Object)response);
        this.helper.setResponse(response.getStatusLine().getStatusCode(), response.getEntity() == null ? null : response.getEntity().getContent(), this.revertHeaders(response.getAllHeaders()));
    }

    protected void addIgnoredHeaders(String ... names) {
        this.helper.addIgnoredHeaders(names);
    }

    boolean isSslHostnameValidationEnabled() {
        return this.sslHostnameValidationEnabled;
    }

    protected long getContentLength(HttpServletRequest request) {
        if (this.useServlet31) {
            return request.getContentLengthLong();
        }
        String contentLengthHeader = request.getHeader("Content-Length");
        if (contentLengthHeader != null) {
            try {
                return Long.parseLong(contentLengthHeader);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return request.getContentLength();
    }
}

