/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.MessageAndSpan;
import org.springframework.cloud.sleuth.instrument.messaging.MessageAndSpans;
import org.springframework.cloud.sleuth.instrument.messaging.MessageHeaderPropagatorSetter;
import org.springframework.cloud.sleuth.instrument.messaging.TriConsumer;
import org.springframework.cloud.sleuth.internal.SpanNameUtil;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.core.ResolvableType;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.StringUtils;

class TraceMessageHandler {
    private static final Log log = LogFactory.getLog(TraceMessageHandler.class);
    private static final String REMOTE_SERVICE_NAME = "broker";
    private static final String TRACE_HANDLER_PARENT_SPAN = "traceHandlerParentSpan";
    final Tracer tracer;
    private final Propagator propagator;
    private final Propagator.Setter<MessageHeaderAccessor> injector;
    private final Propagator.Getter<MessageHeaderAccessor> extractor;
    private final Function<Span, Span> preSendFunction;
    private final TriConsumer<MessageHeaderAccessor, Span, Span> preSendMessageManipulator;
    private final Function<Span, Span.Builder> outputMessageSpanFunction;

    TraceMessageHandler(Tracer tracer, Propagator propagator, Propagator.Setter<MessageHeaderAccessor> injector, Propagator.Getter<MessageHeaderAccessor> extractor, Function<Span, Span> preSendFunction, TriConsumer<MessageHeaderAccessor, Span, Span> preSendMessageManipulator, Function<Span, Span.Builder> outputMessageSpanFunction) {
        this.tracer = tracer;
        this.propagator = propagator;
        this.injector = injector;
        this.extractor = extractor;
        this.preSendFunction = preSendFunction;
        this.preSendMessageManipulator = preSendMessageManipulator;
        this.outputMessageSpanFunction = outputMessageSpanFunction;
    }

    static TraceMessageHandler forNonSpringIntegration(Tracer tracer, Propagator propagator, Propagator.Setter<MessageHeaderAccessor> injector, Propagator.Getter<MessageHeaderAccessor> extractor) {
        Function<Span, Span> preSendFunction = span -> tracer.nextSpan(span).name("handle").start();
        TriConsumer<MessageHeaderAccessor, Span, Span> preSendMessageManipulator = (headers, parentSpan, childSpan) -> {
            headers.setHeader(TRACE_HANDLER_PARENT_SPAN, parentSpan);
            headers.setHeader(Span.class.getName(), childSpan);
        };
        Function<Span, Span.Builder> postReceiveFunction = span -> tracer.spanBuilder().setParent(span.context());
        return new TraceMessageHandler(tracer, propagator, injector, extractor, preSendFunction, preSendMessageManipulator, postReceiveFunction);
    }

    static TraceMessageHandler forNonSpringIntegration(BeanFactory beanFactory) {
        Propagator.Setter setter = TraceMessageHandler.firstBeanOrException(beanFactory, Propagator.Setter.class);
        Propagator.Getter getter = TraceMessageHandler.firstBeanOrException(beanFactory, Propagator.Getter.class);
        return TraceMessageHandler.forNonSpringIntegration((Tracer)beanFactory.getBean(Tracer.class), (Propagator)beanFactory.getBean(Propagator.class), (Propagator.Setter<MessageHeaderAccessor>)setter, (Propagator.Getter<MessageHeaderAccessor>)getter);
    }

    private static <T> T firstBeanOrException(BeanFactory beanFactory, Class<T> clazz) {
        T object;
        ObjectProvider setterObjectProvider = beanFactory.getBeanProvider(ResolvableType.forClassWithGenerics(clazz, (Class[])new Class[]{MessageHeaderAccessor.class}));
        T t = object = setterObjectProvider.iterator().hasNext() ? (T)setterObjectProvider.iterator().next() : null;
        if (object == null) {
            throw new NoSuchBeanDefinitionException("No Propagator.Setter has been defined");
        }
        return object;
    }

    MessageAndSpans wrapInputMessage(Message<?> message, String destinationName) {
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(message);
        Span extracted = this.propagator.extract((Object)headers, this.extractor).start();
        Span.Builder consumerSpanBuilder = this.tracer.spanBuilder().setParent(extracted.context());
        Span consumerSpan = this.consumerSpan(destinationName, extracted, consumerSpanBuilder);
        Span span = this.preSendFunction.apply(consumerSpan);
        this.clearTracingHeaders(headers);
        this.preSendMessageManipulator.accept(headers, consumerSpan, span);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a handle span after retrieving the message " + consumerSpanBuilder));
        }
        if (message instanceof ErrorMessage) {
            return new MessageAndSpans((Message)new ErrorMessage((Throwable)message.getPayload(), headers.getMessageHeaders()), consumerSpan, span);
        }
        headers.setImmutable();
        return new MessageAndSpans((Message)new GenericMessage(message.getPayload(), headers.getMessageHeaders()), consumerSpan, span);
    }

    private Span consumerSpan(String destinationName, Span extracted, Span.Builder consumerSpanBuilder) {
        Span consumerSpan;
        if (!extracted.isNoop()) {
            consumerSpanBuilder.kind(Span.Kind.CONSUMER).start();
            this.addTags(consumerSpanBuilder, destinationName);
            consumerSpanBuilder.remoteServiceName(REMOTE_SERVICE_NAME);
            consumerSpan = consumerSpanBuilder.start();
            consumerSpan.end();
        } else {
            consumerSpan = consumerSpanBuilder.start();
        }
        return consumerSpan;
    }

    Span spanFromMessage(Message<?> message) {
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(message);
        Span span = this.span(headers, Span.class.getName());
        if (span != null) {
            return span;
        }
        span = this.span(headers, TRACE_HANDLER_PARENT_SPAN);
        if (span != null) {
            return span;
        }
        return this.propagator.extract((Object)headers, this.extractor).start();
    }

    private void addTags(Span.Builder result, String destinationName) {
        if (StringUtils.hasText((String)destinationName)) {
            result.tag("channel", SpanNameUtil.shorten(destinationName));
        }
    }

    private void addTags(Span result, String destinationName) {
        if (StringUtils.hasText((String)destinationName)) {
            result.tag("channel", SpanNameUtil.shorten(destinationName));
        }
    }

    void afterMessageHandled(Span span, Throwable ex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will finish the current span after message handled " + span));
        }
        this.finishSpan(span, ex);
    }

    Span parentSpan(Message message) {
        return this.span(this.mutableHeaderAccessor(message), TRACE_HANDLER_PARENT_SPAN);
    }

    Span consumerSpan(Message message) {
        return this.span(this.mutableHeaderAccessor(message), Span.class.getName());
    }

    private Span span(MessageHeaderAccessor headerAccessor, String key) {
        return (Span)headerAccessor.getMessageHeaders().get((Object)key, Span.class);
    }

    MessageAndSpan wrapOutputMessage(Message<?> message, Span parentSpan, String destinationName) {
        Message<?> retrievedMessage = this.getMessage(message);
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(retrievedMessage);
        Span.Builder span = this.outputMessageSpanFunction.apply(parentSpan);
        this.clearTracingHeaders(headers);
        Span producerSpan = this.createProducerSpan(headers, span, destinationName);
        this.propagator.inject(producerSpan.context(), (Object)headers, this.injector);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a new span output message " + span));
        }
        return new MessageAndSpan(this.outputMessage(message, retrievedMessage, headers), producerSpan);
    }

    private Span createProducerSpan(MessageHeaderAccessor headers, Span.Builder spanBuilder, String destinationName) {
        spanBuilder.kind(Span.Kind.PRODUCER).name("send").remoteServiceName(this.toRemoteServiceName(headers));
        Span span = spanBuilder.start();
        if (!span.isNoop()) {
            this.addTags(spanBuilder, destinationName);
        }
        return span;
    }

    private String toRemoteServiceName(MessageHeaderAccessor headers) {
        for (String key : headers.getMessageHeaders().keySet()) {
            if (key.startsWith("kafka_")) {
                return "kafka";
            }
            if (!key.startsWith("amqp_")) continue;
            return "rabbitmq";
        }
        return REMOTE_SERVICE_NAME;
    }

    private Message<?> outputMessage(Message<?> originalMessage, Message<?> retrievedMessage, MessageHeaderAccessor additionalHeaders) {
        MessageHeaderAccessor headers = this.mutableHeaderAccessor(originalMessage);
        this.clearTechnicalTracingHeaders(headers);
        if (originalMessage instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)originalMessage;
            headers.copyHeaders(MessageHeaderPropagatorSetter.propagationHeaders(additionalHeaders.getMessageHeaders(), this.propagator.fields()));
            return new ErrorMessage((Throwable)errorMessage.getPayload(), this.isWebSockets(headers) ? headers.getMessageHeaders() : new MessageHeaders((Map)headers.getMessageHeaders()), errorMessage.getOriginalMessage());
        }
        headers.copyHeaders((Map)additionalHeaders.getMessageHeaders());
        return new GenericMessage(retrievedMessage.getPayload(), this.isWebSockets(headers) ? headers.getMessageHeaders() : new MessageHeaders((Map)headers.getMessageHeaders()));
    }

    private boolean isWebSockets(MessageHeaderAccessor headerAccessor) {
        return headerAccessor.getMessageHeaders().containsKey((Object)"stompCommand") || headerAccessor.getMessageHeaders().containsKey((Object)"simpMessageType");
    }

    private Message<?> getMessage(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof MessagingException) {
            MessagingException e = (MessagingException)payload;
            Message<?> failedMessage = e.getFailedMessage();
            return failedMessage != null ? failedMessage : message;
        }
        return message;
    }

    private MessageHeaderAccessor mutableHeaderAccessor(Message<?> message) {
        MessageHeaderAccessor accessor = MessageHeaderAccessor.getAccessor(message, MessageHeaderAccessor.class);
        if (accessor != null && accessor.isMutable()) {
            return accessor;
        }
        MessageHeaderAccessor headers = MessageHeaderAccessor.getMutableAccessor(message);
        headers.setLeaveMutable(true);
        return headers;
    }

    private void clearTracingHeaders(MessageHeaderAccessor headers) {
        ArrayList<String> keysToRemove = new ArrayList<String>(this.propagator.fields());
        keysToRemove.add(Span.class.getName());
        keysToRemove.add(TRACE_HANDLER_PARENT_SPAN);
        MessageHeaderPropagatorSetter.removeAnyTraceHeaders(headers, keysToRemove);
    }

    private void clearTechnicalTracingHeaders(MessageHeaderAccessor headers) {
        MessageHeaderPropagatorSetter.removeAnyTraceHeaders(headers, Arrays.asList(Span.class.getName(), TRACE_HANDLER_PARENT_SPAN));
    }

    private void finishSpan(Span span, Throwable error) {
        if (span == null || span.isNoop()) {
            return;
        }
        if (error != null) {
            String message = error.getMessage();
            if (message == null) {
                message = error.getClass().getSimpleName();
            }
            span.tag("error", message);
        }
        span.end();
    }
}

