/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.springframework.cloud.sleuth.instrument.reactor.SleuthConnectableLift;
import org.springframework.cloud.sleuth.instrument.reactor.SleuthFluxLift;
import org.springframework.cloud.sleuth.instrument.reactor.SleuthGroupedLift;
import org.springframework.cloud.sleuth.instrument.reactor.SleuthMonoLift;
import org.springframework.cloud.sleuth.instrument.reactor.SleuthParallelLift;
import org.springframework.cloud.sleuth.instrument.reactor.TraceContextPropagator;
import org.springframework.util.Assert;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.GroupedFlux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ParallelFlux;
import reactor.util.annotation.Nullable;

final class ReactorHooksHelper {
    static final Class<?> sourceProducerClass;

    private ReactorHooksHelper() {
    }

    public static boolean shouldDecorate(Publisher<?> p) {
        Assert.notNull(p, (String)"source Publisher is null");
        Publisher<?> current = p;
        while (current != null) {
            if (current instanceof Fuseable.ScalarCallable) {
                return false;
            }
            if (ReactorHooksHelper.isTraceContextPropagator(current)) {
                return false;
            }
            if (!ReactorHooksHelper.isSync(current)) {
                return true;
            }
            if (ReactorHooksHelper.isSourceProducer(current)) {
                return false;
            }
            current = ReactorHooksHelper.getParent(current);
        }
        return true;
    }

    static boolean isTraceContextPropagator(Publisher<?> current) {
        return current instanceof TraceContextPropagator;
    }

    private static boolean isSourceProducer(Publisher<?> p) {
        return sourceProducerClass.isInstance(p);
    }

    private static boolean isSync(Publisher<?> p) {
        return !(p instanceof Processor) && Scannable.Attr.RunStyle.SYNC == Scannable.from(p).scan(Scannable.Attr.RUN_STYLE);
    }

    @Nullable
    private static Publisher<?> getParent(Publisher<?> publisher) {
        Object parent = Scannable.from(publisher).scanUnsafe(Scannable.Attr.PARENT);
        if (parent instanceof Publisher) {
            return (Publisher)parent;
        }
        return null;
    }

    public static <O> Function<? super Publisher<O>, ? extends Publisher<O>> liftPublisher(Predicate<Publisher> filter, BiFunction<Publisher, ? super CoreSubscriber<? super O>, ? extends CoreSubscriber<? super O>> lifter) {
        Assert.notNull(lifter, (String)"lifter is null");
        return publisher -> {
            if (filter != null && !filter.test((Publisher)publisher)) {
                return publisher;
            }
            if (publisher instanceof Mono) {
                return new SleuthMonoLift(publisher, lifter);
            }
            if (publisher instanceof ParallelFlux) {
                return new SleuthParallelLift((ParallelFlux)publisher, lifter);
            }
            if (publisher instanceof ConnectableFlux) {
                return new SleuthConnectableLift((ConnectableFlux)publisher, lifter);
            }
            if (publisher instanceof GroupedFlux) {
                return new SleuthGroupedLift((GroupedFlux)publisher, lifter);
            }
            return new SleuthFluxLift(publisher, lifter);
        };
    }

    static {
        Class<Object> c;
        try {
            c = Class.forName("reactor.core.publisher.SourceProducer");
        }
        catch (ClassNotFoundException e) {
            c = Void.class;
        }
        sourceProducerClass = c;
    }
}

