/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.mvc;

import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.context.ApplicationContext;
import org.springframework.web.method.HandlerMethod;

abstract class WebMvcRuntime {
    private static final WebMvcRuntime WEBMVC_RUNTIME = WebMvcRuntime.findWebMvcRuntime();

    abstract CurrentTraceContext currentTraceContext(ApplicationContext var1);

    abstract HttpServerHandler httpServerHandler(ApplicationContext var1);

    abstract boolean isHandlerMethod(Object var1);

    WebMvcRuntime() {
    }

    static WebMvcRuntime get() {
        return WEBMVC_RUNTIME;
    }

    static WebMvcRuntime findWebMvcRuntime() {
        try {
            Class.forName("org.springframework.web.method.HandlerMethod");
            return new WebMvc31();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException("Pre Spring Web 3.1 not supported");
        }
    }

    static final class WebMvc31
    extends WebMvcRuntime {
        WebMvc31() {
        }

        @Override
        CurrentTraceContext currentTraceContext(ApplicationContext ctx) {
            return (CurrentTraceContext)ctx.getBean(CurrentTraceContext.class);
        }

        @Override
        HttpServerHandler httpServerHandler(ApplicationContext ctx) {
            return (HttpServerHandler)ctx.getBean(HttpServerHandler.class);
        }

        @Override
        boolean isHandlerMethod(Object handler) {
            return handler instanceof HandlerMethod;
        }
    }
}

