/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2;

import java.net.URI;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.zipkin2.StaticInstanceZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.ZipkinLoadBalancer;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin2.ZipkinUrlExtractor;

public class CachingZipkinUrlExtractor
implements ZipkinUrlExtractor {
    private static final Log log = LogFactory.getLog(CachingZipkinUrlExtractor.class);
    final AtomicInteger zipkinPort = new AtomicInteger();
    private final ZipkinLoadBalancer zipkinLoadBalancer;

    public CachingZipkinUrlExtractor(ZipkinLoadBalancer zipkinLoadBalancer) {
        this.zipkinLoadBalancer = zipkinLoadBalancer;
    }

    @Override
    public URI zipkinUrl(ZipkinProperties zipkinProperties) {
        int cachedZipkinPort = this.zipkinPort(zipkinProperties);
        if (cachedZipkinPort == -1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The port in Zipkin's URL [" + zipkinProperties.getBaseUrl() + "] wasn't provided - that means that load balancing might take place"));
            }
            return this.zipkinLoadBalancer.instance();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("The port in Zipkin's URL [" + zipkinProperties.getBaseUrl() + "] is provided - that means that load balancing will not take place"));
        }
        return this.noOpZipkinLoadBalancer(zipkinProperties).instance();
    }

    StaticInstanceZipkinLoadBalancer noOpZipkinLoadBalancer(ZipkinProperties zipkinProperties) {
        return new StaticInstanceZipkinLoadBalancer(zipkinProperties);
    }

    private int zipkinPort(ZipkinProperties zipkinProperties) {
        int cachedZipkinPort = this.zipkinPort.get();
        if (cachedZipkinPort != 0) {
            return cachedZipkinPort;
        }
        return this.calculatePort(zipkinProperties);
    }

    int calculatePort(ZipkinProperties zipkinProperties) {
        String baseUrl = zipkinProperties.getBaseUrl();
        URI uri = this.createUri(baseUrl);
        int zipkinPort = uri.getPort();
        this.zipkinPort.set(zipkinPort);
        return zipkinPort;
    }

    URI createUri(String baseUrl) {
        return URI.create(baseUrl);
    }
}

