/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.metrics;

import java.util.TreeSet;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

class RelaxedPropertiesUtils {
    private static final Pattern HYPHEN_LOWER = Pattern.compile("-_|_-|__|\\.-|\\._");
    private static final Pattern SEPARATED_TO_CAMEL_CASE_PATTERN = Pattern.compile("[_\\-.]");
    private static final char[] SUFFIXES = new char[]{'_', '-', '.'};

    RelaxedPropertiesUtils() {
    }

    public static String findCanonicalFormat(Iterable<String> names) {
        TreeSet<String> sorted = new TreeSet<String>();
        String environmentFormat = null;
        String simpleFormat = null;
        for (String name : names) {
            sorted.add(name);
        }
        String canonicalForm = null;
        for (String name : sorted) {
            if (HYPHEN_LOWER.matcher(name).find()) continue;
            if (RelaxedPropertiesUtils.upperCaseRatio(name) == 1.0) {
                if (name.contains("_")) {
                    environmentFormat = name;
                }
                if (name.matches("^.*?(_|-).*$")) continue;
                simpleFormat = name;
                continue;
            }
            if (!name.contains(".")) continue;
            Object[] keys = name.split("\\.");
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = RelaxedPropertiesUtils.separatedToCamelCase((String)keys[i], false);
            }
            canonicalForm = StringUtils.arrayToDelimitedString((Object[])keys, (String)".");
            break;
        }
        if (canonicalForm == null) {
            if (environmentFormat != null) {
                canonicalForm = environmentFormat.toLowerCase().replace("_", ".");
            }
            if (canonicalForm == null && simpleFormat != null) {
                canonicalForm = simpleFormat.toLowerCase();
            }
        }
        return canonicalForm;
    }

    private static double upperCaseRatio(String input) {
        int upperCaseCount = 0;
        String compare = input.replaceAll("[._-]", "");
        for (int i = 0; i < compare.length(); ++i) {
            if (!Character.isUpperCase(compare.charAt(i))) continue;
            ++upperCaseCount;
        }
        return (float)upperCaseCount / (float)compare.length();
    }

    private static String separatedToCamelCase(String value, boolean caseInsensitive) {
        if (value.isEmpty()) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        for (String field : SEPARATED_TO_CAMEL_CASE_PATTERN.split(value)) {
            field = caseInsensitive ? field.toLowerCase() : field;
            builder.append(builder.length() == 0 ? field : StringUtils.capitalize((String)field));
        }
        char lastChar = value.charAt(value.length() - 1);
        for (char suffix : SUFFIXES) {
            if (lastChar != suffix) continue;
            builder.append(suffix);
            break;
        }
        return builder.toString();
    }
}

