/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.stream.binding.SupportedBindableFeatures;
import org.springframework.cloud.stream.function.BindableFunctionProxyFactory;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

public class PollableSourceInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    public void initialize(GenericApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        if (StringUtils.hasText((String)environment.getProperty("spring.cloud.stream.pollable-source"))) {
            String[] sourceNames;
            for (String sourceName : sourceNames = environment.getProperty("spring.cloud.stream.pollable-source").split(";")) {
                SupportedBindableFeatures supportedBindableFeatures = new SupportedBindableFeatures();
                supportedBindableFeatures.setPollable(true);
                supportedBindableFeatures.setReactive(false);
                BindableFunctionProxyFactory proxyFactory = new BindableFunctionProxyFactory(sourceName, 1, 0, new StreamFunctionProperties(), supportedBindableFeatures);
                applicationContext.registerBean(sourceName + "_binding", BindableFunctionProxyFactory.class, () -> proxyFactory, new BeanDefinitionCustomizer[0]);
            }
        }
    }
}

