/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.cloud.vault.config.ClientAuthenticationFactory;
import org.springframework.cloud.vault.config.DefaultRestTemplateFactory;
import org.springframework.cloud.vault.config.DefaultWebClientFactory;
import org.springframework.cloud.vault.config.KeyValueSecretBackendMetadata;
import org.springframework.cloud.vault.config.LeasingSecretBackendMetadata;
import org.springframework.cloud.vault.config.SecretBackendMetadata;
import org.springframework.cloud.vault.config.VaultAutoConfiguration;
import org.springframework.cloud.vault.config.VaultConfigLocation;
import org.springframework.cloud.vault.config.VaultConfigOperations;
import org.springframework.cloud.vault.config.VaultConfigTemplate;
import org.springframework.cloud.vault.config.VaultConfiguration;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.cloud.vault.config.VaultPropertySource;
import org.springframework.cloud.vault.config.VaultReactiveConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.AuthenticationStepsFactory;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.ReactiveSessionManager;
import org.springframework.vault.authentication.SessionManager;
import org.springframework.vault.authentication.VaultTokenSupplier;
import org.springframework.vault.client.RestTemplateBuilder;
import org.springframework.vault.client.RestTemplateFactory;
import org.springframework.vault.client.SimpleVaultEndpointProvider;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.client.VaultEndpointProvider;
import org.springframework.vault.client.WebClientBuilder;
import org.springframework.vault.client.WebClientFactory;
import org.springframework.vault.config.AbstractVaultConfiguration;
import org.springframework.vault.core.ReactiveVaultTemplate;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.core.env.LeaseAwareVaultPropertySource;
import org.springframework.vault.core.lease.SecretLeaseContainer;
import org.springframework.vault.core.lease.domain.RequestedSecret;
import org.springframework.vault.core.lease.event.LeaseErrorListener;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class VaultConfigDataLoader
implements ConfigDataLoader<VaultConfigLocation> {
    private static final boolean FLUX_AVAILABLE = ClassUtils.isPresent((String)"reactor.core.publisher.Flux", (ClassLoader)VaultConfigDataLoader.class.getClassLoader());
    private static final boolean WEBCLIENT_AVAILABLE = ClassUtils.isPresent((String)"org.springframework.web.reactive.function.client.WebClient", (ClassLoader)VaultConfigDataLoader.class.getClassLoader());
    private static final boolean REGISTER_REACTIVE_INFRASTRUCTURE = FLUX_AVAILABLE && WEBCLIENT_AVAILABLE;

    public ConfigData load(ConfigDataLoaderContext context, VaultConfigLocation location) throws IOException, ConfigDataLocationNotFoundException {
        ConfigurableBootstrapContext bootstrap = context.getBootstrapContext();
        VaultProperties vaultProperties = (VaultProperties)bootstrap.get(VaultProperties.class);
        if (vaultProperties.getSession().getLifecycle().isEnabled() || vaultProperties.getConfig().getLifecycle().isEnabled()) {
            this.registerVaultTaskScheduler(bootstrap);
        }
        this.registerImperativeInfrastructure(bootstrap, vaultProperties);
        if (REGISTER_REACTIVE_INFRASTRUCTURE) {
            this.registerReactiveInfrastructure(bootstrap, vaultProperties);
        }
        this.registerVaultConfigTemplate(bootstrap, vaultProperties);
        if (vaultProperties.getConfig().getLifecycle().isEnabled()) {
            this.registerSecretLeaseContainer(bootstrap, new VaultConfiguration(vaultProperties));
        }
        return this.loadConfigData(location, bootstrap, vaultProperties);
    }

    private ConfigData loadConfigData(VaultConfigLocation location, ConfigurableBootstrapContext bootstrap, VaultProperties vaultProperties) {
        if (vaultProperties.getConfig().getLifecycle().isEnabled()) {
            RequestedSecret secret = this.getRequestedSecret(location.getSecretBackendMetadata());
            if (vaultProperties.isFailFast()) {
                return new ConfigData(Collections.singleton(this.createLeasingPropertySourceFailFast((SecretLeaseContainer)bootstrap.get(SecretLeaseContainer.class), secret, location.getSecretBackendMetadata())), new ConfigData.Option[0]);
            }
            return VaultConfigDataLoader.createConfigData(() -> this.createLeasingPropertySource((SecretLeaseContainer)bootstrap.get(SecretLeaseContainer.class), secret, location.getSecretBackendMetadata()));
        }
        return VaultConfigDataLoader.createConfigData(() -> {
            VaultConfigTemplate configTemplate = (VaultConfigTemplate)bootstrap.get(VaultConfigTemplate.class);
            return this.createVaultPropertySource(configTemplate, vaultProperties.isFailFast(), location.getSecretBackendMetadata());
        });
    }

    private void registerImperativeInfrastructure(ConfigurableBootstrapContext bootstrap, VaultProperties vaultProperties) {
        ImperativeInfrastructure infra = new ImperativeInfrastructure(bootstrap, vaultProperties);
        infra.registerClientHttpRequestFactoryWrapper();
        infra.registerRestTemplateBuilder();
        infra.registerVaultRestTemplateFactory();
        VaultProperties.AuthenticationMethod authentication = vaultProperties.getAuthentication();
        if (authentication == VaultProperties.AuthenticationMethod.NONE) {
            VaultConfigDataLoader.registerIfAbsent(bootstrap, "vaultTemplate", VaultTemplate.class, (BootstrapContext ctx) -> new VaultTemplate((RestTemplateBuilder)ctx.get(RestTemplateBuilder.class)));
        } else {
            infra.registerClientAuthentication();
            if (!REGISTER_REACTIVE_INFRASTRUCTURE) {
                infra.registerVaultSessionManager();
            }
            VaultConfigDataLoader.registerIfAbsent(bootstrap, "vaultTemplate", VaultTemplate.class, (BootstrapContext ctx) -> new VaultTemplate((RestTemplateBuilder)bootstrap.get(RestTemplateBuilder.class), (SessionManager)bootstrap.get(SessionManager.class)));
        }
    }

    private void registerReactiveInfrastructure(ConfigurableBootstrapContext bootstrap, VaultProperties vaultProperties) {
        ReactiveInfrastructure reactiveInfrastructure = new ReactiveInfrastructure(bootstrap, vaultProperties);
        reactiveInfrastructure.registerClientHttpConnector();
        reactiveInfrastructure.registerWebClientBuilder();
        reactiveInfrastructure.registerWebClientFactory();
        VaultProperties.AuthenticationMethod authentication = vaultProperties.getAuthentication();
        if (authentication == VaultProperties.AuthenticationMethod.NONE) {
            VaultConfigDataLoader.registerIfAbsent(bootstrap, "reactiveVaultTemplate", ReactiveVaultTemplate.class, (BootstrapContext ctx) -> new ReactiveVaultTemplate((WebClientBuilder)ctx.get(WebClientBuilder.class)));
        } else {
            reactiveInfrastructure.registerTokenSupplier();
            reactiveInfrastructure.registerReactiveSessionManager();
            reactiveInfrastructure.registerSessionManager();
            VaultConfigDataLoader.registerIfAbsent(bootstrap, "reactiveVaultTemplate", ReactiveVaultTemplate.class, (BootstrapContext ctx) -> new ReactiveVaultTemplate((WebClientBuilder)bootstrap.get(WebClientBuilder.class), (VaultTokenSupplier)bootstrap.get(ReactiveSessionManager.class)));
        }
    }

    static ConfigData createConfigData(Supplier<PropertySource<?>> propertySourceSupplier) {
        return new ConfigData(Collections.singleton(propertySourceSupplier.get()), new ConfigData.Option[0]);
    }

    private void registerVaultConfigTemplate(ConfigurableBootstrapContext bootstrap, VaultProperties vaultProperties) {
        bootstrap.registerIfAbsent(VaultConfigTemplate.class, ctx -> new VaultConfigTemplate((VaultOperations)ctx.get(VaultTemplate.class), vaultProperties));
    }

    private void registerVaultTaskScheduler(ConfigurableBootstrapContext bootstrap) {
        VaultConfigDataLoader.registerIfAbsent(bootstrap, "vaultTaskScheduler", VaultAutoConfiguration.TaskSchedulerWrapper.class, () -> {
            ThreadPoolTaskScheduler scheduler = VaultConfiguration.createScheduler();
            scheduler.afterPropertiesSet();
            return new VaultAutoConfiguration.TaskSchedulerWrapper(scheduler, false);
        }, ConfigurableApplicationContext::registerShutdownHook);
    }

    private void registerSecretLeaseContainer(ConfigurableBootstrapContext bootstrap, VaultConfiguration vaultConfiguration) {
        VaultConfigDataLoader.registerIfAbsent(bootstrap, "secretLeaseContainer", SecretLeaseContainer.class, (BootstrapContext ctx) -> {
            SecretLeaseContainer container = vaultConfiguration.createSecretLeaseContainer((VaultOperations)ctx.get(VaultTemplate.class), () -> ((VaultAutoConfiguration.TaskSchedulerWrapper)ctx.get(VaultAutoConfiguration.TaskSchedulerWrapper.class)).getTaskScheduler());
            try {
                container.afterPropertiesSet();
            }
            catch (Exception e) {
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            container.start();
            return container;
        }, ConfigurableApplicationContext::registerShutdownHook);
    }

    private PropertySource<?> createVaultPropertySource(VaultConfigOperations configOperations, boolean failFast, SecretBackendMetadata accessor) {
        VaultPropertySource vaultPropertySource = new VaultPropertySource(configOperations, failFast, accessor);
        vaultPropertySource.init();
        return vaultPropertySource;
    }

    private PropertySource<?> createLeasingPropertySource(SecretLeaseContainer secretLeaseContainer, RequestedSecret secret, SecretBackendMetadata accessor) {
        if (accessor instanceof LeasingSecretBackendMetadata) {
            ((LeasingSecretBackendMetadata)accessor).beforeRegistration(secret, secretLeaseContainer);
        }
        LeaseAwareVaultPropertySource propertySource = new LeaseAwareVaultPropertySource(accessor.getName(), secretLeaseContainer, secret, accessor.getPropertyTransformer());
        if (accessor instanceof LeasingSecretBackendMetadata) {
            ((LeasingSecretBackendMetadata)accessor).afterRegistration(secret, secretLeaseContainer);
        }
        return propertySource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertySource<?> createLeasingPropertySourceFailFast(SecretLeaseContainer secretLeaseContainer, RequestedSecret secret, SecretBackendMetadata accessor) {
        PropertySource<?> propertySource;
        AtomicReference errorRef = new AtomicReference();
        LeaseErrorListener errorListener = (leaseEvent, exception) -> {
            if (leaseEvent.getSource() == secret) {
                errorRef.compareAndSet(null, exception);
            }
        };
        secretLeaseContainer.addErrorListener(errorListener);
        try {
            propertySource = this.createLeasingPropertySource(secretLeaseContainer, secret, accessor);
        }
        catch (Throwable throwable) {
            secretLeaseContainer.removeLeaseErrorListener(errorListener);
            Exception exception2 = (Exception)errorRef.get();
            if (exception2 != null) {
                if (exception2 instanceof VaultException) {
                    throw (VaultException)exception2;
                }
                throw new VaultException(String.format("Cannot initialize PropertySource for secret at %s", secret.getPath()), (Throwable)exception2);
            }
            throw throwable;
        }
        secretLeaseContainer.removeLeaseErrorListener(errorListener);
        Exception exception3 = (Exception)errorRef.get();
        if (exception3 != null) {
            if (exception3 instanceof VaultException) {
                throw (VaultException)exception3;
            }
            throw new VaultException(String.format("Cannot initialize PropertySource for secret at %s", secret.getPath()), (Throwable)exception3);
        }
        return propertySource;
    }

    private RequestedSecret getRequestedSecret(SecretBackendMetadata accessor) {
        if (accessor instanceof LeasingSecretBackendMetadata) {
            LeasingSecretBackendMetadata leasingBackend = (LeasingSecretBackendMetadata)accessor;
            return RequestedSecret.from((RequestedSecret.Mode)leasingBackend.getLeaseMode(), (String)accessor.getPath());
        }
        if (accessor instanceof KeyValueSecretBackendMetadata) {
            return RequestedSecret.rotating((String)accessor.getPath());
        }
        return RequestedSecret.renewable((String)accessor.getPath());
    }

    static <T> void registerIfAbsent(ConfigurableBootstrapContext bootstrap, String beanName, Class<T> instanceType, Supplier<T> instanceSupplier) {
        VaultConfigDataLoader.registerIfAbsent(bootstrap, beanName, instanceType, (BootstrapContext ctx) -> instanceSupplier.get(), (ConfigurableApplicationContext ctx) -> {});
    }

    static <T> void registerIfAbsent(ConfigurableBootstrapContext bootstrap, String beanName, Class<T> instanceType, Supplier<T> instanceSupplier, Consumer<ConfigurableApplicationContext> contextCustomizer) {
        VaultConfigDataLoader.registerIfAbsent(bootstrap, beanName, instanceType, (BootstrapContext ctx) -> instanceSupplier.get(), contextCustomizer);
    }

    static <T> void registerIfAbsent(ConfigurableBootstrapContext bootstrap, String beanName, Class<T> instanceType, Function<BootstrapContext, T> instanceSupplier) {
        VaultConfigDataLoader.registerIfAbsent(bootstrap, beanName, instanceType, instanceSupplier, (ConfigurableApplicationContext ctx) -> {});
    }

    static <T> void registerIfAbsent(ConfigurableBootstrapContext bootstrap, String beanName, Class<T> instanceType, Function<BootstrapContext, T> instanceSupplier, Consumer<ConfigurableApplicationContext> contextCustomizer) {
        bootstrap.registerIfAbsent(instanceType, instanceSupplier::apply);
        bootstrap.addCloseListener(event -> {
            GenericApplicationContext gac = (GenericApplicationContext)event.getApplicationContext();
            contextCustomizer.accept((ConfigurableApplicationContext)gac);
            Object instance = event.getBootstrapContext().get(instanceType);
            gac.registerBean(beanName, instanceType, () -> instance, new BeanDefinitionCustomizer[0]);
        });
    }

    private static class NonInitializingClientFactoryWrapper
    extends AbstractVaultConfiguration.ClientFactoryWrapper {
        NonInitializingClientFactoryWrapper(ClientHttpRequestFactory clientHttpRequestFactory) {
            super(clientHttpRequestFactory);
        }

        public void afterPropertiesSet() {
        }
    }

    static class ReactiveInfrastructure {
        private final ConfigurableBootstrapContext bootstrap;
        private final VaultReactiveConfiguration configuration;
        private final VaultEndpointProvider endpointProvider;

        ReactiveInfrastructure(ConfigurableBootstrapContext bootstrap, VaultProperties vaultProperties) {
            this.bootstrap = bootstrap;
            this.configuration = new VaultReactiveConfiguration(vaultProperties);
            this.endpointProvider = SimpleVaultEndpointProvider.of((VaultEndpoint)new VaultConfiguration(vaultProperties).createVaultEndpoint());
        }

        void registerClientHttpConnector() {
            this.bootstrap.registerIfAbsent(ClientHttpConnector.class, ctx -> this.configuration.createClientHttpConnector());
        }

        public void registerWebClientBuilder() {
            this.bootstrap.registerIfAbsent(WebClientBuilder.class, ctx -> this.configuration.createWebClientBuilder((ClientHttpConnector)ctx.get(ClientHttpConnector.class), this.endpointProvider, Collections.emptyList()));
        }

        void registerWebClientFactory() {
            VaultConfigDataLoader.registerIfAbsent(this.bootstrap, "vaultWebClientFactory", WebClientFactory.class, ctx -> new DefaultWebClientFactory((ClientHttpConnector)ctx.get(ClientHttpConnector.class), connector -> this.configuration.createWebClientBuilder((ClientHttpConnector)connector, this.endpointProvider, Collections.emptyList())));
        }

        void registerTokenSupplier() {
            VaultConfigDataLoader.registerIfAbsent(this.bootstrap, "vaultTokenSupplier", VaultTokenSupplier.class, ctx -> this.configuration.createVaultTokenSupplier((WebClientFactory)ctx.get(WebClientFactory.class), () -> {
                if (this.bootstrap.isRegistered(AuthenticationStepsFactory.class)) {
                    return (AuthenticationStepsFactory)this.bootstrap.get(AuthenticationStepsFactory.class);
                }
                return null;
            }, () -> {
                if (this.bootstrap.isRegistered(ClientAuthentication.class)) {
                    return (ClientAuthentication)this.bootstrap.get(ClientAuthentication.class);
                }
                return null;
            }));
        }

        void registerReactiveSessionManager() {
            VaultConfigDataLoader.registerIfAbsent(this.bootstrap, "reactiveVaultSessionManager", ReactiveSessionManager.class, ctx -> this.configuration.createReactiveSessionManager((VaultTokenSupplier)ctx.get(VaultTokenSupplier.class), () -> ((VaultAutoConfiguration.TaskSchedulerWrapper)ctx.get(VaultAutoConfiguration.TaskSchedulerWrapper.class)).getTaskScheduler(), (WebClientFactory)ctx.get(WebClientFactory.class)));
        }

        void registerSessionManager() {
            VaultConfigDataLoader.registerIfAbsent(this.bootstrap, "vaultSessionManager", SessionManager.class, ctx -> this.configuration.createSessionManager((ReactiveSessionManager)ctx.get(ReactiveSessionManager.class)));
        }
    }

    static class ImperativeInfrastructure {
        private final ConfigurableBootstrapContext bootstrap;
        private final VaultProperties vaultProperties;
        private final VaultConfiguration configuration;
        private final VaultEndpointProvider endpointProvider;

        ImperativeInfrastructure(ConfigurableBootstrapContext bootstrap, VaultProperties vaultProperties) {
            this.bootstrap = bootstrap;
            this.vaultProperties = vaultProperties;
            this.configuration = new VaultConfiguration(vaultProperties);
            this.endpointProvider = SimpleVaultEndpointProvider.of((VaultEndpoint)this.configuration.createVaultEndpoint());
        }

        void registerClientHttpRequestFactoryWrapper() {
            VaultConfigDataLoader.registerIfAbsent(this.bootstrap, "clientHttpRequestFactoryWrapper", AbstractVaultConfiguration.ClientFactoryWrapper.class, () -> {
                ClientHttpRequestFactory factory = this.configuration.createClientHttpRequestFactory();
                try {
                    new AbstractVaultConfiguration.ClientFactoryWrapper(factory).afterPropertiesSet();
                }
                catch (Exception e) {
                    ReflectionUtils.rethrowRuntimeException((Throwable)e);
                }
                return new NonInitializingClientFactoryWrapper(factory);
            });
        }

        void registerRestTemplateBuilder() {
            this.bootstrap.registerIfAbsent(RestTemplateBuilder.class, ctx -> this.configuration.createRestTemplateBuilder(((AbstractVaultConfiguration.ClientFactoryWrapper)ctx.get(AbstractVaultConfiguration.ClientFactoryWrapper.class)).getClientHttpRequestFactory(), this.endpointProvider, Collections.emptyList(), Collections.emptyList()));
        }

        void registerVaultRestTemplateFactory() {
            VaultConfigDataLoader.registerIfAbsent(this.bootstrap, "vaultRestTemplateFactory", RestTemplateFactory.class, ctx -> new DefaultRestTemplateFactory(((AbstractVaultConfiguration.ClientFactoryWrapper)ctx.get(AbstractVaultConfiguration.ClientFactoryWrapper.class)).getClientHttpRequestFactory(), requestFactory -> this.configuration.createRestTemplateBuilder((ClientHttpRequestFactory)requestFactory, this.endpointProvider, Collections.emptyList(), Collections.emptyList())));
        }

        void registerClientAuthentication() {
            VaultConfigDataLoader.registerIfAbsent(this.bootstrap, "clientAuthentication", ClientAuthentication.class, ctx -> {
                ClientHttpRequestFactory factory = ((AbstractVaultConfiguration.ClientFactoryWrapper)this.bootstrap.get(AbstractVaultConfiguration.ClientFactoryWrapper.class)).getClientHttpRequestFactory();
                RestTemplate externalRestTemplate = new RestTemplate(factory);
                ClientAuthenticationFactory authenticationFactory = new ClientAuthenticationFactory(this.vaultProperties, (RestOperations)((RestTemplateFactory)this.bootstrap.get(RestTemplateFactory.class)).create(), (RestOperations)externalRestTemplate);
                return authenticationFactory.createClientAuthentication();
            });
        }

        void registerVaultSessionManager() {
            VaultConfigDataLoader.registerIfAbsent(this.bootstrap, "vaultSessionManager", SessionManager.class, ctx -> this.configuration.createSessionManager((ClientAuthentication)ctx.get(ClientAuthentication.class), () -> ((VaultAutoConfiguration.TaskSchedulerWrapper)ctx.get(VaultAutoConfiguration.TaskSchedulerWrapper.class)).getTaskScheduler(), (RestTemplateFactory)ctx.get(RestTemplateFactory.class)));
        }
    }
}

