/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.discovery.dependency;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.zookeeper.discovery.dependency.LoadBalancerType;
import org.springframework.cloud.zookeeper.discovery.dependency.StubsConfiguration;
import org.springframework.util.StringUtils;

public class ZookeeperDependency {
    private static final String VERSION_PLACEHOLDER_REGEX = "\\$version";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private String path;
    private LoadBalancerType loadBalancerType = LoadBalancerType.ROUND_ROBIN;
    private String contentTypeTemplate = "";
    private String version = "";
    private Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
    private boolean required;
    private String stubs;
    private StubsConfiguration stubsConfiguration;

    public ZookeeperDependency() {
    }

    public ZookeeperDependency(String path, LoadBalancerType loadBalancerType, String contentTypeTemplate, String version, Map<String, Collection<String>> headers, boolean required, String stubs) {
        this.path = path;
        this.loadBalancerType = loadBalancerType;
        this.contentTypeTemplate = contentTypeTemplate;
        this.version = version;
        this.headers = headers;
        this.required = required;
        this.stubs = stubs;
    }

    public ZookeeperDependency(String path) {
        if (StringUtils.hasText((String)path)) {
            this.path = path;
        }
    }

    public String getContentTypeWithVersion() {
        if (!StringUtils.hasText((String)this.contentTypeTemplate) || !StringUtils.hasText((String)this.version)) {
            return "";
        }
        return this.contentTypeTemplate.replaceAll(VERSION_PLACEHOLDER_REGEX, this.version);
    }

    public Map<String, Collection<String>> getUpdatedHeaders(Map<String, Collection<String>> headers) {
        HashMap<String, Collection<String>> newHeaders = new HashMap<String, Collection<String>>(headers);
        if (this.hasContentTypeTemplate()) {
            this.setContentTypeFromTemplate(newHeaders);
        }
        if (this.hasHeadersSet()) {
            this.addPredefinedHeaders(newHeaders);
        }
        return newHeaders;
    }

    private void setContentTypeFromTemplate(Map<String, Collection<String>> headers) {
        Collection<String> contentTypes = headers.get(CONTENT_TYPE_HEADER);
        if (contentTypes == null || contentTypes.isEmpty()) {
            headers.put(CONTENT_TYPE_HEADER, Collections.singletonList(this.getContentTypeWithVersion()));
        } else {
            contentTypes.add(this.getContentTypeWithVersion());
        }
    }

    private void addPredefinedHeaders(Map<String, Collection<String>> newHeaders) {
        for (Map.Entry<String, Collection<String>> entry : this.headers.entrySet()) {
            Collection<String> value = newHeaders.get(entry.getKey());
            if (value == null || value.isEmpty()) {
                newHeaders.put(entry.getKey(), entry.getValue());
                continue;
            }
            value.addAll(entry.getValue());
        }
    }

    private boolean hasContentTypeTemplate() {
        return StringUtils.hasText((String)this.contentTypeTemplate);
    }

    private boolean hasHeadersSet() {
        return !this.headers.isEmpty();
    }

    public String getPath() {
        return this.path;
    }

    public LoadBalancerType getLoadBalancerType() {
        return this.loadBalancerType;
    }

    public String getContentTypeTemplate() {
        return this.contentTypeTemplate;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Collection<String>> getHeaders() {
        return this.headers;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getStubs() {
        return this.stubs;
    }

    public StubsConfiguration getStubsConfiguration() {
        return this.stubsConfiguration;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setLoadBalancerType(LoadBalancerType loadBalancerType) {
        this.loadBalancerType = loadBalancerType;
    }

    public void setContentTypeTemplate(String contentTypeTemplate) {
        this.contentTypeTemplate = contentTypeTemplate;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setHeaders(Map<String, Collection<String>> headers) {
        this.headers = headers;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setStubs(String stubs) {
        this.stubs = stubs;
    }

    public void setStubsConfiguration(StubsConfiguration stubsConfiguration) {
        this.stubsConfiguration = stubsConfiguration;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ZookeeperDependency{");
        sb.append("path='").append(this.path).append('\'');
        sb.append(", loadBalancerType=").append((Object)this.loadBalancerType);
        sb.append(", contentTypeTemplate='").append(this.contentTypeTemplate).append('\'');
        sb.append(", version='").append(this.version).append('\'');
        sb.append(", headers=").append(this.headers);
        sb.append(", required=").append(this.required);
        sb.append(", stubs='").append(this.stubs).append('\'');
        sb.append(", stubsConfiguration=").append(this.stubsConfiguration);
        sb.append('}');
        return sb.toString();
    }
}

