/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper.serviceregistry;

import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.curator.x.discovery.details.JsonInstanceSerializer;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.serviceregistry.ServiceRegistryAutoConfiguration;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.zookeeper.discovery.ConditionalOnZookeeperDiscoveryEnabled;
import org.springframework.cloud.zookeeper.discovery.ZookeeperDiscoveryProperties;
import org.springframework.cloud.zookeeper.discovery.ZookeeperInstance;
import org.springframework.cloud.zookeeper.serviceregistry.ZookeeperServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnZookeeperDiscoveryEnabled
@ConditionalOnProperty(value={"spring.cloud.service-registry.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={ServiceRegistryAutoConfiguration.class})
public class ZookeeperServiceRegistryAutoConfiguration
implements ApplicationContextAware {
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    @Bean
    public ZookeeperServiceRegistry zookeeperServiceRegistry() {
        return new ZookeeperServiceRegistry((ServiceDiscovery<ZookeeperInstance>)((ServiceDiscovery)this.context.getBean(ServiceDiscovery.class)));
    }

    @Bean
    @ConditionalOnMissingBean
    public InstanceSerializer<ZookeeperInstance> instanceSerializer() {
        return new JsonInstanceSerializer(ZookeeperInstance.class);
    }

    @Bean
    @ConditionalOnMissingBean
    public ZookeeperDiscoveryProperties zookeeperDiscoveryProperties(InetUtils inetUtils) {
        return new ZookeeperDiscoveryProperties(inetUtils);
    }
}

