/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.cql.generator.CqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.CreateIndexSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateUserTypeSpecification;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public class CassandraPersistentEntitySchemaCreator {
    private final CassandraAdminOperations cassandraAdminOperations;
    private final CassandraMappingContext mappingContext;

    public CassandraPersistentEntitySchemaCreator(CassandraAdminOperations cassandraAdminOperations) {
        Assert.notNull((Object)cassandraAdminOperations, (String)"CassandraAdminOperations must not be null");
        this.cassandraAdminOperations = cassandraAdminOperations;
        this.mappingContext = cassandraAdminOperations.getConverter().getMappingContext();
    }

    public CassandraPersistentEntitySchemaCreator(CassandraMappingContext mappingContext, CassandraAdminOperations cassandraAdminOperations) {
        Assert.notNull((Object)cassandraAdminOperations, (String)"CassandraAdminOperations must not be null");
        Assert.notNull((Object)((Object)mappingContext), (String)"CassandraMappingContext must not be null");
        this.cassandraAdminOperations = cassandraAdminOperations;
        this.mappingContext = mappingContext;
    }

    public void createTables(boolean ifNotExists) {
        this.createTableSpecifications(ifNotExists).stream().map(CqlGenerator::toCql).forEach(cql -> this.cassandraAdminOperations.getCqlOperations().execute((String)cql));
    }

    protected List<CreateTableSpecification> createTableSpecifications(boolean ifNotExists) {
        return this.mappingContext.getTableEntities().stream().map(entity -> this.cassandraAdminOperations.getSchemaFactory().getCreateTableSpecificationFor((CassandraPersistentEntity<?>)entity).ifNotExists(ifNotExists)).collect(Collectors.toList());
    }

    public void createIndexes(boolean ifNotExists) {
        this.createIndexSpecifications(ifNotExists).stream().map(CqlGenerator::toCql).forEach(cql -> this.cassandraAdminOperations.getCqlOperations().execute((String)cql));
    }

    protected List<CreateIndexSpecification> createIndexSpecifications(boolean ifNotExists) {
        return this.mappingContext.getTableEntities().stream().flatMap(entity -> this.cassandraAdminOperations.getSchemaFactory().getCreateIndexSpecificationsFor((CassandraPersistentEntity<?>)entity).stream()).peek(it -> it.ifNotExists(ifNotExists)).collect(Collectors.toList());
    }

    public void createUserTypes(boolean ifNotExists) {
        this.createUserTypeSpecifications(ifNotExists).stream().map(CqlGenerator::toCql).forEach(cql -> this.cassandraAdminOperations.getCqlOperations().execute((String)cql));
    }

    protected List<CreateUserTypeSpecification> createUserTypeSpecifications(boolean ifNotExists) {
        ArrayList entities = new ArrayList(this.mappingContext.getUserDefinedTypeEntities());
        Map<CqlIdentifier, CassandraPersistentEntity> byTableName = entities.stream().collect(Collectors.toMap(CassandraPersistentEntity::getTableName, entity -> entity));
        ArrayList<CreateUserTypeSpecification> specifications = new ArrayList<CreateUserTypeSpecification>();
        UserDefinedTypeSet udts = new UserDefinedTypeSet();
        entities.forEach(entity -> {
            udts.add(entity.getTableName());
            this.visitUserTypes((CassandraPersistentEntity<?>)entity, udts);
        });
        specifications.addAll(udts.stream().map(identifier -> this.cassandraAdminOperations.getSchemaFactory().getCreateUserTypeSpecificationFor((CassandraPersistentEntity)byTableName.get(identifier)).ifNotExists(ifNotExists)).collect(Collectors.toList()));
        return specifications;
    }

    private void visitUserTypes(CassandraPersistentEntity<?> entity, UserDefinedTypeSet udts) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            BasicCassandraPersistentEntity propertyType = (BasicCassandraPersistentEntity)this.mappingContext.getPersistentEntity(property);
            if (propertyType == null || !propertyType.isUserDefinedType()) continue;
            if (udts.add(propertyType.getTableName())) {
                this.visitUserTypes(propertyType, udts);
            }
            udts.addDependency(entity.getTableName(), propertyType.getTableName());
        }
    }

    static class UserDefinedTypeSet
    implements Streamable<CqlIdentifier> {
        private final Set<CqlIdentifier> seen = new HashSet<CqlIdentifier>();
        private final List<DependencyNode> creationOrder = new ArrayList<DependencyNode>();

        UserDefinedTypeSet() {
        }

        public boolean add(CqlIdentifier cqlIdentifier) {
            if (this.seen.add(cqlIdentifier)) {
                this.creationOrder.add(new DependencyNode(cqlIdentifier));
                return true;
            }
            return false;
        }

        public Iterator<CqlIdentifier> iterator() {
            return this.creationOrder.stream().sorted((left, right) -> {
                if (left.dependsOn(right.getIdentifier())) {
                    return 1;
                }
                if (right.dependsOn(left.getIdentifier())) {
                    return -1;
                }
                return 0;
            }).map(DependencyNode::getIdentifier).iterator();
        }

        void addDependency(CqlIdentifier typeToCreate, CqlIdentifier dependsOn) {
            for (DependencyNode toCreate : this.creationOrder) {
                if (!toCreate.matches(typeToCreate)) continue;
                toCreate.addDependency(dependsOn);
            }
        }

        static class DependencyNode {
            private final CqlIdentifier identifier;
            private final List<CqlIdentifier> dependsOn = new ArrayList<CqlIdentifier>();

            DependencyNode(CqlIdentifier identifier) {
                this.identifier = identifier;
            }

            public CqlIdentifier getIdentifier() {
                return this.identifier;
            }

            boolean matches(CqlIdentifier typeToCreate) {
                return this.identifier.equals((Object)typeToCreate);
            }

            void addDependency(CqlIdentifier dependsOn) {
                this.dependsOn.add(dependsOn);
            }

            boolean dependsOn(CqlIdentifier identifier) {
                return this.dependsOn.contains(identifier);
            }
        }
    }
}

