/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.cql.Row;
import org.jspecify.annotations.Nullable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;

enum RowReaderPropertyAccessor implements PropertyAccessor
{
    INSTANCE;


    public Class<?>[] getSpecificTargetClasses() {
        return new Class[]{Row.class};
    }

    public boolean canRead(EvaluationContext context, @Nullable Object target, String name) {
        return target != null && ((Row)target).getColumnDefinitions().contains(name);
    }

    public TypedValue read(EvaluationContext context, @Nullable Object target, String name) {
        if (target == null) {
            return TypedValue.NULL;
        }
        Row row = (Row)target;
        if (row.isNull(name)) {
            return TypedValue.NULL;
        }
        return new TypedValue(row.getObject(name));
    }

    public boolean canWrite(EvaluationContext context, @Nullable Object target, String name) {
        return false;
    }

    public void write(EvaluationContext context, @Nullable Object target, String name, @Nullable Object newValue) {
        throw new UnsupportedOperationException();
    }
}

