/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.Statement;
import org.springframework.util.Assert;

@FunctionalInterface
public interface ExecutionProfileResolver {
    public Statement<?> apply(Statement<?> var1);

    public static ExecutionProfileResolver none() {
        return statement -> statement;
    }

    public static ExecutionProfileResolver from(DriverExecutionProfile driverExecutionProfile) {
        Assert.notNull((Object)driverExecutionProfile, (String)"DriverExecutionProfile must not be null");
        return statement -> statement.setExecutionProfile(driverExecutionProfile);
    }

    public static ExecutionProfileResolver from(String profileName) {
        Assert.hasText((String)profileName, (String)"DriverExecutionProfile name must not be empty");
        return statement -> statement.setExecutionProfileName(profileName);
    }
}

