/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.ReactiveSessionFactory;
import org.springframework.data.cassandra.core.cql.CassandraExceptionTranslator;
import org.springframework.data.cassandra.core.cql.CqlExceptionTranslator;
import org.springframework.data.cassandra.core.cql.QueryExtractorDelegate;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public abstract class ReactiveCassandraAccessor
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CqlExceptionTranslator exceptionTranslator = new CassandraExceptionTranslator();
    private @Nullable ReactiveSessionFactory sessionFactory;

    public void setSessionFactory(ReactiveSessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"ReactiveSessionFactory must not be null");
        this.sessionFactory = sessionFactory;
    }

    public @Nullable ReactiveSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setExceptionTranslator(CqlExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)exceptionTranslator, (String)"CQLExceptionTranslator must not be null");
        this.exceptionTranslator = exceptionTranslator;
    }

    public CqlExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.sessionFactory, (String)"ReactiveSessionFactory must not be null");
    }

    protected @Nullable DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        Assert.notNull((Object)ex, (String)"DriverException must not be null");
        return this.getExceptionTranslator().translateExceptionIfPossible(ex);
    }

    protected DataAccessException translate(String task, @Nullable String cql, RuntimeException ex) {
        Assert.notNull((Object)ex, (String)"DriverException must not be null");
        return this.getExceptionTranslator().translate(task, cql, ex);
    }

    @Contract(value="null -> null; !null -> !null")
    protected static @Nullable String toCql(@Nullable Object cqlProvider) {
        return QueryExtractorDelegate.getCql(cqlProvider);
    }
}

