/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.PreparedStatementCreator;
import org.springframework.util.Assert;

public class SimplePreparedStatementCreator
implements PreparedStatementCreator,
CqlProvider {
    private final SimpleStatement statement;

    public SimplePreparedStatementCreator(String cql) {
        Assert.notNull((Object)cql, (String)"CQL is required to create a PreparedStatement");
        this.statement = SimpleStatement.newInstance((String)cql);
    }

    public SimplePreparedStatementCreator(SimpleStatement statement) {
        Assert.notNull((Object)statement, (String)"CQL is required to create a PreparedStatement");
        this.statement = statement;
    }

    @Override
    public PreparedStatement createPreparedStatement(CqlSession session) throws DriverException {
        return session.prepare(this.statement);
    }

    @Override
    public String getCql() {
        return this.statement.getQuery();
    }
}

