/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.cql.keyspace.CqlStringUtils;
import org.springframework.data.cassandra.core.cql.keyspace.TableNameSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.TableOption;
import org.springframework.util.ClassUtils;

public abstract class TableOptionsSpecification<T extends TableOptionsSpecification<T>>
extends TableNameSpecification {
    private final Map<String, @Nullable Object> options = new LinkedHashMap<String, Object>();

    protected TableOptionsSpecification(CqlIdentifier name) {
        super(name);
    }

    protected TableOptionsSpecification(@Nullable CqlIdentifier keyspace, CqlIdentifier name) {
        super(keyspace, name);
    }

    public T with(TableOption option) {
        if (option.requiresValue() && ClassUtils.resolvePrimitiveIfNecessary(option.getType()) == Boolean.class) {
            return this.with(option.getName(), true, option.escapesValue(), option.quotesValue());
        }
        return this.with(option.getName(), null);
    }

    public T with(TableOption option, Object value) {
        option.checkValue(value);
        return this.with(option.getName(), value, option.escapesValue(), option.quotesValue());
    }

    public T with(String name, @Nullable Object value) {
        return this.with(name, value, false, true);
    }

    public T with(String name, @Nullable Object value, boolean escape, boolean quote) {
        if (!(value instanceof Map)) {
            if (escape) {
                value = CqlStringUtils.escapeSingle(value);
            }
            if (quote) {
                value = CqlStringUtils.singleQuote(value);
            }
        }
        this.options.put(name, value);
        return (T)this;
    }

    public Map<String, @Nullable Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }
}

