/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;

public interface CassandraPersistentEntity<T>
extends PersistentEntity<T, CassandraPersistentProperty> {
    public @Nullable CassandraPersistentProperty getProperty(Parameter<?, CassandraPersistentProperty> var1);

    public boolean isCompositePrimaryKey();

    public CqlIdentifier getTableName();

    public void setTableName(CqlIdentifier var1);

    public @Nullable CqlIdentifier getKeyspace();

    default public CqlIdentifier getRequiredKeyspace() {
        CqlIdentifier keyspace = this.getKeyspace();
        if (keyspace == null) {
            throw new IllegalStateException(String.format("No keyspace specified for %s", this));
        }
        return keyspace;
    }

    default public boolean hasKeyspace() {
        return this.getKeyspace() != null;
    }

    public void setKeyspace(CqlIdentifier var1);

    public boolean isTupleType();

    public boolean isUserDefinedType();
}

