/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.aot;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.CassandraScrollPosition;
import org.springframework.data.cassandra.repository.aot.LikeParameterBinding;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.cassandra.repository.query.CassandraParametersParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryCreator;
import org.springframework.data.cassandra.repository.query.ParameterBinding;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

class AotQueryCreator
extends CassandraQueryCreator {
    public AotQueryCreator(PartTree tree, CassandraParameters parameters, MappingContext<?, CassandraPersistentProperty> mappingContext, List<ParameterBinding> parameterBindings) {
        super(tree, new AotPlaceholderParameterAccessor(parameters, parameterBindings), mappingContext);
    }

    @Override
    protected Object like(Part.Type type, Object value) {
        if (value instanceof ParameterBinding) {
            ParameterBinding pb = (ParameterBinding)value;
            return new LikeParameterBinding(pb, type);
        }
        return super.like(type, value);
    }

    static class AotPlaceholderParameterAccessor
    extends CassandraParametersParameterAccessor {
        private final List<ParameterBinding> parameterBindings;

        public AotPlaceholderParameterAccessor(CassandraParameters parameters, List<ParameterBinding> parameterBindings) {
            super(parameters, new Object[parameters.getNumberOfParameters()]);
            this.parameterBindings = parameterBindings;
        }

        @Override
        public @Nullable Object getValue(int parameterIndex) {
            ParameterBinding binding = ParameterBinding.indexed(parameterIndex);
            this.parameterBindings.add(binding);
            return binding;
        }

        @Override
        public CassandraScrollPosition getScrollPosition() {
            return null;
        }

        @Override
        public @Nullable ScoringFunction getScoringFunction() {
            return null;
        }

        @Override
        public @Nullable QueryOptions getQueryOptions() {
            return null;
        }

        public @Nullable Object getBindableValue(int index) {
            return this.getValue(((CassandraParameters.CassandraParameter)this.getParameters().getBindableParameter(index)).getIndex());
        }

        public boolean hasBindableNullValue() {
            return false;
        }
    }
}

