/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.aot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.repository.Query;
import org.springframework.data.cassandra.repository.aot.AotQuery;
import org.springframework.data.cassandra.repository.aot.AotQueryCreator;
import org.springframework.data.cassandra.repository.aot.DerivedAotQuery;
import org.springframework.data.cassandra.repository.aot.StringAotQuery;
import org.springframework.data.cassandra.repository.config.CassandraRepositoryConfigurationExtension;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.ParameterBinding;
import org.springframework.data.cassandra.repository.query.StringBasedQuery;
import org.springframework.data.domain.Sort;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.config.PropertiesBasedNamedQueriesFactoryBean;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.PropertiesBasedNamedQueries;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.StringUtils;

class QueriesFactory {
    private final NamedQueries namedQueries;
    private final ValueExpressionDelegate delegate;
    private final CassandraMappingContext mappingContext;
    private final StatementFactory statementFactory;

    public QueriesFactory(RepositoryConfigurationSource configurationSource, ClassLoader classLoader, ValueExpressionDelegate delegate, CassandraMappingContext mappingContext) {
        this.namedQueries = this.getNamedQueries(configurationSource, classLoader);
        this.delegate = delegate;
        this.mappingContext = mappingContext;
        UpdateMapper updateMapper = new UpdateMapper(new MappingCassandraConverter(mappingContext)){

            @Override
            protected @Nullable Object getMappedValue(QueryMapper.Field field, CriteriaDefinition.Operator operator, Object value) {
                return value;
            }
        };
        this.statementFactory = new StatementFactory(updateMapper);
    }

    private NamedQueries getNamedQueries(RepositoryConfigurationSource configSource, ClassLoader classLoader) {
        String location = configSource.getNamedQueryLocation().orElse(null);
        if (location == null) {
            location = new CassandraRepositoryConfigurationExtension().getDefaultNamedQueryLocation();
        }
        if (StringUtils.hasText((String)location)) {
            try {
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
                PropertiesBasedNamedQueriesFactoryBean factoryBean = new PropertiesBasedNamedQueriesFactoryBean();
                factoryBean.setLocations(resolver.getResources(location));
                factoryBean.afterPropertiesSet();
                return (NamedQueries)Objects.requireNonNull(factoryBean.getObject());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new PropertiesBasedNamedQueries(new Properties());
    }

    public AotQuery createQuery(RepositoryInformation repositoryInformation, ReturnedType returnedType, MergedAnnotation<Query> query2, CassandraQueryMethod queryMethod) {
        boolean exists;
        boolean count = query2.isPresent() && query2.getBoolean("count");
        boolean bl = exists = query2.isPresent() && query2.getBoolean("exists");
        if (query2.isPresent() && StringUtils.hasText((String)query2.getString("value"))) {
            return this.buildStringQuery(query2.getString("value"), queryMethod, count, exists);
        }
        String queryName = queryMethod.getNamedQueryName();
        if (this.namedQueries.hasQuery(queryName)) {
            return this.buildNamedQuery(queryName, queryMethod, count, exists);
        }
        return this.buildPartTreeQuery(repositoryInformation, returnedType, queryMethod);
    }

    private AotQuery buildStringQuery(String queryString, CassandraQueryMethod queryMethod, boolean count, boolean exists) {
        StringBasedQuery query2 = this.parseQuery(queryMethod, queryString);
        List<ParameterBinding> bindings = query2.getQueryParameterBindings();
        return StringAotQuery.of(query2.getPostProcessedQuery(), bindings, count, exists);
    }

    private AotQuery buildNamedQuery(String queryName, CassandraQueryMethod queryMethod, boolean count, boolean exists) {
        String queryString = this.namedQueries.getQuery(queryName);
        StringBasedQuery query2 = this.parseQuery(queryMethod, queryString);
        List<ParameterBinding> bindings = query2.getQueryParameterBindings();
        return StringAotQuery.named(queryName, query2.getPostProcessedQuery(), bindings, count, exists);
    }

    private StringBasedQuery parseQuery(CassandraQueryMethod queryMethod, String queryString) {
        return new StringBasedQuery(queryString, queryMethod.getParameters(), (ValueExpressionParser)this.delegate);
    }

    private AotQuery buildPartTreeQuery(RepositoryInformation repositoryInformation, ReturnedType returnedType, CassandraQueryMethod queryMethod) {
        PartTree partTree = new PartTree(queryMethod.getName(), repositoryInformation.getDomainType());
        ArrayList<ParameterBinding> parameterBindings = new ArrayList<ParameterBinding>();
        AotQueryCreator queryCreator = new AotQueryCreator(partTree, queryMethod.getParameters(), (MappingContext<?, CassandraPersistentProperty>)this.mappingContext, (List<ParameterBinding>)parameterBindings);
        BasicCassandraPersistentEntity entity = (BasicCassandraPersistentEntity)this.mappingContext.getRequiredPersistentEntity(repositoryInformation.getDomainType());
        org.springframework.data.cassandra.core.query.Query query2 = (org.springframework.data.cassandra.core.query.Query)queryCreator.createQuery(Sort.unsorted());
        String queryString = partTree.isDelete() ? this.statementFactory.delete(query2, entity).build().getQuery() : (partTree.isCountProjection() || partTree.isExistsProjection() ? this.statementFactory.count(query2, entity).build().getQuery() : this.statementFactory.select(query2, entity).build().getQuery());
        return new DerivedAotQuery(queryString, parameterBindings, query2, partTree);
    }
}

