/*
 * Copyright 2022-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.aot;

import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.support.RegisteredBean;

/**
 * Extension to {@link BeanRegistrationAotContribution} that bases its contribution on a {@link RegisteredBean}. This
 * interface exposes its {@link #getSource() source}.
 *
 * @author Christoph Strobl
 * @since 3.0
 */
public interface RegisteredBeanAotContribution extends BeanRegistrationAotContribution {

	/**
	 * @return the source {@link RegisteredBean}.
	 */
	RegisteredBean getSource();
}
