/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.io.Serializable;
import org.springframework.data.domain.Pageable;

public abstract class AbstractPageRequest
implements Pageable,
Serializable {
    private static final long serialVersionUID = 1232825578694716871L;
    private final int pageNumber;
    private final int pageSize;

    public AbstractPageRequest(int pageNumber, int pageSize) {
        if (pageNumber < 0) {
            throw new IllegalArgumentException("Page index must not be less than zero");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("Page size must not be less than one");
        }
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public long getOffset() {
        return (long)this.pageNumber * (long)this.pageSize;
    }

    @Override
    public boolean hasPrevious() {
        return this.pageNumber > 0;
    }

    @Override
    public Pageable previousOrFirst() {
        return this.hasPrevious() ? this.previous() : this.first();
    }

    @Override
    public abstract Pageable next();

    public abstract Pageable previous();

    @Override
    public abstract Pageable first();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pageNumber;
        result = 31 * result + this.pageSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPageRequest other = (AbstractPageRequest)obj;
        return this.pageNumber == other.pageNumber && this.pageSize == other.pageSize;
    }
}

