/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeReference;
import org.springframework.core.DecoratingProxy;
import org.springframework.data.projection.TargetAware;

public interface AotTypeConfiguration {
    public AotTypeConfiguration forDataBinding();

    public AotTypeConfiguration forReflectiveAccess(MemberCategory ... var1);

    public AotTypeConfiguration contributeAccessors();

    default public AotTypeConfiguration usedAsProjectionInterface() {
        return this.proxyInterface(TargetAware.class, SpringProxy.class, DecoratingProxy.class);
    }

    default public AotTypeConfiguration springProxy() {
        return this.proxyInterface(SpringProxy.class, Advised.class, DecoratingProxy.class);
    }

    default public AotTypeConfiguration repositoryProxy() {
        this.springProxy();
        List<TypeReference> transactionalProxy = List.of(TypeReference.of((String)"org.springframework.data.repository.Repository"), TypeReference.of((String)"org.springframework.transaction.interceptor.TransactionalProxy"), TypeReference.of((String)"org.springframework.aop.framework.Advised"), TypeReference.of(DecoratingProxy.class));
        this.proxyInterface(transactionalProxy);
        this.proxyInterface(Stream.concat(transactionalProxy.stream(), Stream.of(TypeReference.of(Serializable.class))).toList());
        return this;
    }

    public AotTypeConfiguration proxyInterface(List<TypeReference> var1);

    default public AotTypeConfiguration proxyInterface(Class<?> ... proxyInterfaces) {
        return this.proxyInterface(Stream.of(proxyInterfaces).map(TypeReference::of).toList());
    }

    public AotTypeConfiguration forQuerydsl();
}

