/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.javapoet;

import java.lang.reflect.Type;
import java.util.Arrays;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.ArrayTypeName;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.javapoet.TypeName;
import org.springframework.util.ClassUtils;

public abstract class TypeNames {
    public static TypeName classNameOrWrapper(Class<?> type) {
        return ClassUtils.isPrimitiveOrWrapper(type) ? TypeName.get((Type)ClassUtils.resolvePrimitiveIfNecessary(type)) : TypeName.get(type);
    }

    public static TypeName classNameOrWrapper(ResolvableType resolvableType) {
        return TypeNames.classNameOrWrapper(resolvableType.toClass());
    }

    public static TypeName className(ResolvableType resolvableType) {
        return TypeName.get((Type)resolvableType.toClass());
    }

    public static TypeName resolvedTypeName(ResolvableType resolvableType) {
        if (resolvableType.equals((Object)ResolvableType.NONE)) {
            return TypeName.get(Object.class);
        }
        if (resolvableType.hasResolvableGenerics()) {
            return ParameterizedTypeName.get((ClassName)ClassName.get((Class)resolvableType.toClass()), (TypeName[])((TypeName[])Arrays.stream(resolvableType.getGenerics()).map(TypeNames::resolvedTypeName).toArray(TypeName[]::new)));
        }
        if (!resolvableType.hasGenerics()) {
            Class resolvedType = resolvableType.toClass();
            if (!resolvableType.isArray() || resolvedType.isArray()) {
                return TypeName.get((Type)resolvedType);
            }
            if (resolvableType.isArray()) {
                return ArrayTypeName.of((Type)resolvedType);
            }
            return TypeName.get((Type)resolvedType);
        }
        return ClassName.get((Class)resolvableType.toClass());
    }

    public static TypeName typeName(ResolvableType resolvableType) {
        return TypeName.get((Type)resolvableType.getType());
    }

    public static TypeName typeNameOrWrapper(Class<?> type) {
        return TypeNames.typeNameOrWrapper(ResolvableType.forClass(type));
    }

    public static TypeName typeNameOrWrapper(ResolvableType resolvableType) {
        return ClassUtils.isPrimitiveOrWrapper((Class)resolvableType.toClass()) ? TypeName.get((Type)ClassUtils.resolvePrimitiveIfNecessary((Class)resolvableType.toClass())) : TypeNames.resolvedTypeName(resolvableType);
    }

    private TypeNames() {
    }
}

