/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedFiles;
import org.springframework.aot.generate.GeneratedTypeReference;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeReference;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.repository.aot.generate.AotRepositoryClassBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryCreator;
import org.springframework.data.repository.aot.generate.AotRepositoryFragmentMetadata;
import org.springframework.data.repository.aot.generate.JSONException;
import org.springframework.data.repository.aot.generate.MethodContributor;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.JavaFile;
import org.springframework.javapoet.TypeSpec;
import org.springframework.util.StringUtils;

public class RepositoryContributor {
    private static final Log logger = LogFactory.getLog(RepositoryContributor.class);
    private static final Log jsonLogger = LogFactory.getLog((String)(RepositoryContributor.class.getName() + ".json"));
    private static final String FEATURE_NAME = "AotRepository";
    private final AotRepositoryContext repositoryContext;
    private final AotRepositoryCreator creator;
    private @Nullable TypeReference contributedTypeName;

    public RepositoryContributor(AotRepositoryContext repositoryContext) {
        this.repositoryContext = repositoryContext;
        this.creator = AotRepositoryCreator.forRepository(repositoryContext.getRepositoryInformation(), repositoryContext.getModuleName(), this.createProjectionFactory());
    }

    protected ProjectionFactory createProjectionFactory() {
        return new SpelAwareProxyProjectionFactory();
    }

    protected ProjectionFactory getProjectionFactory() {
        return this.creator.getProjectionFactory();
    }

    protected RepositoryInformation getRepositoryInformation() {
        return this.creator.getRepositoryInformation();
    }

    @Nullable TypeReference getContributedTypeName() {
        return this.contributedTypeName;
    }

    AotRepositoryFragmentMetadata getAotFragmentMetadata() {
        return this.creator.getRepositoryMetadata();
    }

    public final void contribute(GenerationContext generationContext) {
        this.creator.customizeClass(this::customizeClass).customizeConstructor(this::customizeConstructor).contributeMethods(this::contributeQueryMethod);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Contributing %s AOT repository implementation for '%s'".formatted(this.repositoryContext.getModuleName(), this.repositoryContext.getRepositoryInformation().getRepositoryInterface().getName()));
        }
        GeneratedClass generatedClass = generationContext.getGeneratedClasses().getOrAddForFeatureComponent(FEATURE_NAME, this.creator.getClassName(), targetTypeSpec -> {
            String repositoryJson;
            AotRepositoryCreator.AotBundle aotBundle = this.creator.create((TypeSpec.Builder)targetTypeSpec);
            String string = repositoryJson = this.repositoryContext.isGeneratedRepositoriesMetadataEnabled() ? this.generateJsonMetadata(aotBundle) : null;
            if (logger.isTraceEnabled()) {
                TypeSpec typeSpec = targetTypeSpec.build();
                JavaFile javaFile = JavaFile.builder((String)this.creator.packageName(), (TypeSpec)typeSpec).build();
                logger.trace((Object)"\n%s\n".formatted(RepositoryContributor.formatTraceMessage("Generated Repository", typeSpec.name(), RepositoryContributor.prefixWithLineNumbers(javaFile.toString()).trim())));
            }
            if (jsonLogger.isTraceEnabled() && StringUtils.hasText((String)repositoryJson)) {
                jsonLogger.trace((Object)"\n%s\n".formatted(RepositoryContributor.formatTraceMessage("Repository.json", aotBundle.repositoryJsonFileName(), repositoryJson)));
            }
            if (StringUtils.hasText((String)repositoryJson)) {
                generationContext.getGeneratedFiles().handleFile(GeneratedFiles.Kind.RESOURCE, aotBundle.repositoryJsonFileName(), fileHandler -> {
                    if (!fileHandler.exists()) {
                        fileHandler.create(() -> new ByteArrayInputStream(repositoryJson.getBytes(StandardCharsets.UTF_8)));
                    }
                });
            }
        });
        this.contributedTypeName = GeneratedTypeReference.of((ClassName)generatedClass.getName());
        generationContext.getRuntimeHints().reflection().registerType(this.contributedTypeName, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
    }

    public static String formatTraceMessage(String title, String label, String content) {
        int remainingLength = 64 - title.length();
        String header = ("= %s: %-" + remainingLength + "." + remainingLength + "s =").formatted(title, RepositoryContributor.formatMaxLength(label, remainingLength - 1));
        return "======================================================================\n%s\n======================================================================\n%s\n======================================================================\n".formatted(header, content);
    }

    private static String formatMaxLength(String name, int length) {
        return name.length() > length ? "\u2026" + name.substring(name.length() - length) : name;
    }

    public static String prefixWithLineNumbers(String contents) {
        List<String> lines = contents.lines().toList();
        int decimals = (int)Math.log10(Math.abs(lines.size())) + 1;
        StringBuilder builder = new StringBuilder();
        int lineNumber = 1;
        for (String s : lines) {
            String formattedLineNumber = String.format("/* %-" + decimals + "d */\t", lineNumber);
            builder.append(formattedLineNumber).append(s).append(System.lineSeparator());
            ++lineNumber;
        }
        return builder.toString();
    }

    private String generateJsonMetadata(AotRepositoryCreator.AotBundle aotBundle) {
        String repositoryJson = "";
        if (this.repositoryContext.isGeneratedRepositoriesMetadataEnabled()) {
            try {
                repositoryJson = aotBundle.metadata().get().toJson().toString(2);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return repositoryJson;
    }

    protected void customizeClass(AotRepositoryClassBuilder builder) {
    }

    protected void customizeConstructor(AotRepositoryConstructorBuilder builder) {
    }

    protected @Nullable MethodContributor<? extends QueryMethod> contributeQueryMethod(Method method) {
        return null;
    }
}

