/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.data.aot.AotContext;
import org.springframework.data.repository.config.AotRepositoryContextSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeCollector;
import org.springframework.data.util.TypeUtils;

class DefaultAotRepositoryContext
extends AotRepositoryContextSupport {
    private final String moduleName;
    private final RepositoryConfigurationSource configurationSource;
    private final AotContext aotContext;
    private final RepositoryInformation repositoryInformation;
    private final Lazy<Set<MergedAnnotation<Annotation>>> resolvedAnnotations = Lazy.of(this::discoverAnnotations);
    private final Lazy<Set<Class<?>>> managedTypes = Lazy.of(this::discoverTypes);
    private Collection<Class<? extends Annotation>> identifyingAnnotations = Collections.emptySet();
    private String beanName;

    public DefaultAotRepositoryContext(RegisteredBean bean, RepositoryInformation repositoryInformation, String moduleName, AotContext aotContext, RepositoryConfigurationSource configurationSource) {
        super(aotContext);
        this.repositoryInformation = repositoryInformation;
        this.moduleName = moduleName;
        this.configurationSource = configurationSource;
        this.aotContext = aotContext;
        this.beanName = bean.getBeanName();
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public RepositoryConfigurationSource getConfigurationSource() {
        return this.configurationSource;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return this.identifyingAnnotations;
    }

    public void setIdentifyingAnnotations(Collection<Class<? extends Annotation>> identifyingAnnotations) {
        this.identifyingAnnotations = identifyingAnnotations;
    }

    @Override
    public RepositoryInformation getRepositoryInformation() {
        return this.repositoryInformation;
    }

    @Override
    public Set<MergedAnnotation<Annotation>> getResolvedAnnotations() {
        return this.resolvedAnnotations.get();
    }

    @Override
    public Set<Class<?>> getResolvedTypes() {
        return this.managedTypes.get();
    }

    @Override
    public AotContext.IntrospectedBeanDefinition introspectBeanDefinition(String beanName) {
        return this.aotContext.introspectBeanDefinition(beanName);
    }

    protected Set<MergedAnnotation<Annotation>> discoverAnnotations() {
        Set annotations = this.getResolvedTypes().stream().flatMap(type -> TypeUtils.resolveUsedAnnotations(type).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        annotations.addAll(TypeUtils.resolveUsedAnnotations(this.repositoryInformation.getRepositoryInterface()));
        return annotations;
    }

    protected Set<Class<?>> discoverTypes() {
        LinkedHashSet types = new LinkedHashSet(TypeCollector.inspect(this.repositoryInformation.getDomainType()).list());
        this.repositoryInformation.getQueryMethods().stream().flatMap(it -> TypeUtils.resolveTypesInSignature(this.repositoryInformation.getRepositoryInterface(), it).stream()).flatMap(it -> TypeCollector.inspect(it).list().stream()).forEach(types::add);
        if (!this.getIdentifyingAnnotations().isEmpty()) {
            Set<Class<?>> classes = this.aotContext.getTypeScanner().scanPackages(this.getConfigurationSource().getBasePackages().toSet()).forTypesAnnotatedWith(this.getIdentifyingAnnotations()).collectAsSet();
            types.addAll(TypeCollector.inspect(classes).list());
        }
        return types;
    }
}

