/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.aot.AotServices;
import org.springframework.core.ResolvableType;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.Predicates;
import org.springframework.data.util.TypeUtils;
import org.springframework.lang.Contract;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class TypeCollector {
    private static final Log logger = LogFactory.getLog(TypeCollector.class);
    private static final AotServices<TypeCollectorFilters> providers = AotServices.factories().load(TypeCollectorFilters.class);
    private Predicate<Class<?>> typeFilter = Predicates.isTrue();
    private Predicate<Method> methodFilter = Predicates.isTrue();
    private Predicate<Field> fieldFilter = Predicates.isTrue();

    public TypeCollector() {
        providers.forEach(provider -> {
            this.filterTypes(provider.classPredicate());
            this.filterMethods(provider.methodPredicate());
            this.filterFields(provider.fieldPredicate());
        });
    }

    @Contract(value="_ -> this")
    public TypeCollector filterTypes(Predicate<Class<?>> filter) {
        this.typeFilter = this.typeFilter.and(filter);
        return this;
    }

    @Contract(value="_ -> this")
    public TypeCollector filterMethods(Predicate<Method> filter) {
        this.methodFilter = this.methodFilter.and(filter);
        return this;
    }

    @Contract(value="_ -> this")
    public TypeCollector filterFields(Predicate<Field> filter) {
        this.fieldFilter = this.fieldFilter.and(filter);
        return this;
    }

    public static ReachableTypes inspect(Class<?> ... types) {
        return TypeCollector.inspect(Arrays.asList(types));
    }

    public static ReachableTypes inspect(Collection<Class<?>> types) {
        return TypeCollector.inspect((TypeCollector it) -> {}, types);
    }

    public static ReachableTypes inspect(Consumer<TypeCollector> collectorCustomizer, Class<?> ... types) {
        return TypeCollector.inspect(collectorCustomizer, Arrays.asList(types));
    }

    public static ReachableTypes inspect(Consumer<TypeCollector> collectorCustomizer, Collection<Class<?>> types) {
        TypeCollector typeCollector = new TypeCollector();
        collectorCustomizer.accept(typeCollector);
        return new ReachableTypes(typeCollector, types);
    }

    private void process(Class<?> root, Consumer<ResolvableType> consumer) {
        this.processType(ResolvableType.forType(root), new InspectionCache(), consumer);
    }

    private void processType(ResolvableType type, InspectionCache cache, Consumer<ResolvableType> callback) {
        if (ResolvableType.NONE.equals((Object)type) || cache.contains(type) || type.toClass().isSynthetic()) {
            return;
        }
        cache.add(type);
        if (this.typeFilter.test(type.toClass())) {
            callback.accept(type);
        }
        LinkedHashSet<Type> additionalTypes = new LinkedHashSet<Type>();
        additionalTypes.addAll(TypeUtils.resolveTypesInSignature(type));
        additionalTypes.addAll(this.visitConstructorsOfType(type));
        additionalTypes.addAll(this.visitMethodsOfType(type));
        additionalTypes.addAll(this.visitFieldsOfType(type));
        if (!ObjectUtils.isEmpty((Object[])type.toClass().getDeclaredClasses())) {
            additionalTypes.addAll(Arrays.asList(type.toClass().getDeclaredClasses()));
        }
        for (Type discoveredType : additionalTypes) {
            this.processType(ResolvableType.forType((Type)discoveredType, (ResolvableType)type), cache, callback);
        }
    }

    private Set<Type> visitConstructorsOfType(ResolvableType type) {
        if (!this.typeFilter.test(type.toClass())) {
            return Collections.emptySet();
        }
        LinkedHashSet discoveredTypes = new LinkedHashSet();
        for (Constructor<?> constructor : type.toClass().getDeclaredConstructors()) {
            if (Predicates.isExcluded(constructor)) continue;
            for (Class<?> signatureType : TypeUtils.resolveTypesInSignature(type.toClass(), constructor)) {
                if (!this.typeFilter.test(signatureType)) continue;
                discoveredTypes.add(signatureType);
            }
        }
        return new HashSet<Type>(discoveredTypes);
    }

    private Set<Type> visitMethodsOfType(ResolvableType type) {
        if (!this.typeFilter.test(type.toClass())) {
            return Collections.emptySet();
        }
        LinkedHashSet discoveredTypes = new LinkedHashSet();
        try {
            ReflectionUtils.doWithLocalMethods((Class)type.toClass(), method -> {
                if (!this.methodFilter.test(method)) {
                    return;
                }
                for (Class<?> signatureType : TypeUtils.resolveTypesInSignature(type.toClass(), method)) {
                    if (!this.typeFilter.test(signatureType)) continue;
                    discoveredTypes.add(signatureType);
                }
            });
        }
        catch (Exception cause) {
            logger.warn((Object)cause);
        }
        return new HashSet<Type>(discoveredTypes);
    }

    private Set<Type> visitFieldsOfType(ResolvableType type) {
        LinkedHashSet<Type> discoveredTypes = new LinkedHashSet<Type>();
        ReflectionUtils.doWithLocalFields((Class)type.toClass(), field -> {
            if (!this.fieldFilter.test(field)) {
                return;
            }
            for (Class<?> signatureType : TypeUtils.resolveTypesInSignature(ResolvableType.forField((Field)field, (ResolvableType)type))) {
                if (!this.typeFilter.test(signatureType)) continue;
                discoveredTypes.add(signatureType);
            }
        });
        return discoveredTypes;
    }

    public static class ReachableTypes {
        private final Iterable<Class<?>> roots;
        private final Lazy<List<Class<?>>> reachableTypes = Lazy.of(this::collect);
        private final TypeCollector typeCollector;

        ReachableTypes(TypeCollector typeCollector, Iterable<Class<?>> roots) {
            this.typeCollector = typeCollector;
            this.roots = roots;
        }

        public void forEach(Consumer<ResolvableType> action) {
            this.roots.forEach((? super T it) -> this.typeCollector.process((Class<?>)it, action));
        }

        public List<Class<?>> list() {
            return this.reachableTypes.get();
        }

        private List<Class<?>> collect() {
            ArrayList target = new ArrayList();
            this.forEach(it -> target.add(it.toClass()));
            return List.copyOf(target);
        }
    }

    static class InspectionCache {
        private final Map<String, ResolvableType> mutableCache = new HashMap<String, ResolvableType>();

        InspectionCache() {
        }

        public void add(ResolvableType resolvableType) {
            this.mutableCache.put(resolvableType.toString(), resolvableType);
        }

        public void clear() {
            this.mutableCache.clear();
        }

        public boolean contains(ResolvableType key) {
            return this.mutableCache.containsKey(key.toString());
        }

        public boolean isEmpty() {
            return this.mutableCache.isEmpty();
        }

        public int size() {
            return this.mutableCache.size();
        }
    }

    public static interface TypeCollectorFilters {
        default public Predicate<Class<?>> classPredicate() {
            return Predicates.isTrue();
        }

        default public Predicate<Field> fieldPredicate() {
            return Predicates.isTrue();
        }

        default public Predicate<Method> methodPredicate() {
            return Predicates.isTrue();
        }
    }

    private static class DefaultTypeCollectorFilters
    implements TypeCollectorFilters {
        private static final Set<String> EXCLUDED_DOMAINS = Set.of("java", "sun.", "jdk.", "reactor.", "kotlinx.", "kotlin.", "org.springframework.core.", "org.springframework.data.mapping.", "org.springframework.data.repository.", "org.springframework.boot.", "org.springframework.context.", "org.springframework.beans.");
        private static final Predicate<Class<?>> PACKAGE_PREDICATE = type -> {
            String packageName = type.getPackageName() + ".";
            for (String excludedDomain : EXCLUDED_DOMAINS) {
                if (!packageName.startsWith(excludedDomain)) continue;
                return true;
            }
            return false;
        };
        private static final Predicate<Class<?>> UNREACHABLE_CLASS = type -> type.isLocalClass() || type.isAnonymousClass();
        private static final Predicate<Member> UNWANTED_FIELDS = Predicates.IS_SYNTHETIC.or(Predicates.IS_JAVA).or(Predicates.declaringClass(PACKAGE_PREDICATE));
        private static final Predicate<Method> UNWANTED_METHODS = Predicates.IS_BRIDGE_METHOD.or(Predicates.IS_STATIC).or(Predicates.IS_SYNTHETIC).or(Predicates.IS_NATIVE).or(Predicates.IS_PRIVATE).or(Predicates.IS_PROTECTED).or(Predicates.IS_OBJECT_MEMBER).or(Predicates.IS_ENUM_MEMBER).or(Predicates.declaringClass(PACKAGE_PREDICATE));

        private DefaultTypeCollectorFilters() {
        }

        @Override
        public Predicate<Class<?>> classPredicate() {
            return UNREACHABLE_CLASS.or(PACKAGE_PREDICATE).negate();
        }

        @Override
        public Predicate<Field> fieldPredicate() {
            return UNWANTED_FIELDS.negate();
        }

        @Override
        public Predicate<Method> methodPredicate() {
            return UNWANTED_METHODS.negate();
        }
    }
}

