/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.query;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.PreferredConstructorDiscoverer;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;

public abstract class ReturnedType {
    private static final Log logger = LogFactory.getLog(ReturnedType.class);
    private static final Map<CacheKey, ReturnedType> cache = new ConcurrentReferenceHashMap(32);
    private final Class<?> domainType;

    protected ReturnedType(Class<?> domainType) {
        this.domainType = domainType;
    }

    public static ReturnedType of(Class<?> returnedType, Class<?> domainType, ProjectionFactory factory) {
        Assert.notNull(returnedType, (String)"Returned type must not be null");
        Assert.notNull(domainType, (String)"Domain type must not be null");
        Assert.notNull((Object)factory, (String)"ProjectionFactory must not be null");
        return cache.computeIfAbsent(CacheKey.of(returnedType, domainType, factory.hashCode()), key -> returnedType.isInterface() ? new ReturnedInterface(factory.getProjectionInformation(returnedType), domainType) : new ReturnedClass(returnedType, domainType));
    }

    public final Class<?> getDomainType() {
        return this.domainType;
    }

    @Contract(value="null -> false")
    public final boolean isInstance(@Nullable Object source) {
        return this.getReturnedType().isInstance(source);
    }

    public abstract Class<?> getReturnedType();

    public abstract boolean isProjecting();

    public boolean isInterfaceProjection() {
        return this.isProjecting() && this.getReturnedType().isInterface();
    }

    public boolean isDtoProjection() {
        return this.isProjecting() && !this.getReturnedType().isInterface();
    }

    public abstract List<String> getInputProperties();

    public boolean hasInputProperties() {
        return !CollectionUtils.isEmpty(this.getInputProperties());
    }

    public abstract boolean needsCustomConstruction();

    public abstract @Nullable Class<?> getTypeToRead();

    private static final class CacheKey {
        private final Class<?> returnedType;
        private final Class<?> domainType;
        private final int projectionFactoryHashCode;

        private CacheKey(Class<?> returnedType, Class<?> domainType, int projectionFactoryHashCode) {
            this.returnedType = returnedType;
            this.domainType = domainType;
            this.projectionFactoryHashCode = projectionFactoryHashCode;
        }

        public static CacheKey of(Class<?> returnedType, Class<?> domainType, int projectionFactoryHashCode) {
            return new CacheKey(returnedType, domainType, projectionFactoryHashCode);
        }

        public Class<?> getReturnedType() {
            return this.returnedType;
        }

        public Class<?> getDomainType() {
            return this.domainType;
        }

        public int getProjectionFactoryHashCode() {
            return this.projectionFactoryHashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.projectionFactoryHashCode != cacheKey.projectionFactoryHashCode) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals(this.returnedType, cacheKey.returnedType)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.domainType, cacheKey.domainType);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode(this.returnedType);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.domainType);
            result = 31 * result + this.projectionFactoryHashCode;
            return result;
        }

        public String toString() {
            return "ReturnedType.CacheKey(returnedType=" + String.valueOf(this.getReturnedType()) + ", domainType=" + String.valueOf(this.getDomainType()) + ", projectionFactoryHashCode=" + this.getProjectionFactoryHashCode() + ")";
        }
    }

    private static final class ReturnedInterface
    extends ReturnedType {
        private final ProjectionInformation information;
        private final Class<?> domainType;
        private final boolean isProjecting;
        private final List<String> inputProperties;

        public ReturnedInterface(ProjectionInformation information, Class<?> domainType) {
            super(domainType);
            Assert.notNull((Object)information, (String)"Projection information must not be null");
            this.information = information;
            this.domainType = domainType;
            this.isProjecting = !information.getType().isAssignableFrom(domainType);
            this.inputProperties = ReturnedInterface.detectInputProperties(information);
        }

        private static List<String> detectInputProperties(ProjectionInformation information) {
            ArrayList<String> properties = new ArrayList<String>();
            for (PropertyDescriptor descriptor : information.getInputProperties()) {
                if (properties.contains(descriptor.getName())) continue;
                properties.add(descriptor.getName());
            }
            return Collections.unmodifiableList(properties);
        }

        @Override
        public Class<?> getReturnedType() {
            return this.information.getType();
        }

        @Override
        public boolean isProjecting() {
            return this.isProjecting;
        }

        @Override
        public boolean isInterfaceProjection() {
            return this.isProjecting();
        }

        @Override
        public boolean isDtoProjection() {
            return false;
        }

        @Override
        public List<String> getInputProperties() {
            return this.inputProperties;
        }

        @Override
        public boolean needsCustomConstruction() {
            return this.isProjecting() && this.information.isClosed();
        }

        @Override
        public @Nullable Class<?> getTypeToRead() {
            return this.isProjecting() && this.information.isClosed() ? null : this.domainType;
        }
    }

    private static final class ReturnedClass
    extends ReturnedType {
        private static final Set<Class<?>> VOID_TYPES = Set.of(Void.class, Void.TYPE);
        private final Class<?> type;
        private final boolean isDto;
        private final @Nullable PreferredConstructor<?, ?> constructor;
        private final Lazy<List<String>> inputProperties;

        public ReturnedClass(Class<?> returnedType, Class<?> domainType) {
            super(domainType);
            Assert.notNull(returnedType, (String)"Returned type must not be null");
            Assert.notNull(domainType, (String)"Domain type must not be null");
            Assert.isTrue((!returnedType.isInterface() ? 1 : 0) != 0, (String)"Returned type must not be an interface");
            this.type = returnedType;
            this.isDto = !Object.class.equals(this.type) && !this.type.isEnum() && !this.isDomainSubtype() && !this.isPrimitiveOrWrapper() && !Number.class.isAssignableFrom(this.type) && !VOID_TYPES.contains(this.type) && !this.type.getPackage().getName().startsWith("java.");
            this.constructor = this.detectConstructor(this.type);
            this.inputProperties = this.constructor == null ? Lazy.of(Collections.emptyList()) : Lazy.of(this::detectConstructorParameterNames);
        }

        @Override
        public Class<?> getReturnedType() {
            return this.type;
        }

        @Override
        public boolean isProjecting() {
            return this.isDto;
        }

        @Override
        public boolean isInterfaceProjection() {
            return false;
        }

        @Override
        public boolean isDtoProjection() {
            return this.isProjecting();
        }

        @Override
        public List<String> getInputProperties() {
            return this.inputProperties.get();
        }

        @Override
        public boolean hasInputProperties() {
            return this.constructor != null && this.constructor.getParameterCount() > 0 && super.hasInputProperties();
        }

        @Override
        public boolean needsCustomConstruction() {
            return this.isDtoProjection() && this.hasInputProperties();
        }

        @Override
        public Class<?> getTypeToRead() {
            return this.type;
        }

        private boolean isDomainSubtype() {
            return this.getDomainType().equals(this.type) && this.getDomainType().isAssignableFrom(this.type);
        }

        private boolean isPrimitiveOrWrapper() {
            return ClassUtils.isPrimitiveOrWrapper(this.type);
        }

        private @Nullable PreferredConstructor<?, ?> detectConstructor(Class<?> type) {
            return this.isDtoProjection() ? PreferredConstructorDiscoverer.discover(type) : null;
        }

        private List<String> detectConstructorParameterNames() {
            if (this.constructor == null) {
                return Collections.emptyList();
            }
            int parameterCount = this.constructor.getConstructor().getParameterCount();
            ArrayList<String> properties = new ArrayList<String>(parameterCount);
            for (Parameter parameter : this.constructor.getParameters()) {
                if (!parameter.hasName()) continue;
                properties.add(parameter.getRequiredName());
            }
            if (properties.isEmpty() && parameterCount > 0 && logger.isWarnEnabled()) {
                logger.warn((Object)"No constructor parameter names discovered. Compile the affected code with '-parameters' instead or avoid its introspection: %s".formatted(this.constructor.getConstructor().getDeclaringClass().getName()));
            }
            return Collections.unmodifiableList(properties);
        }
    }
}

