/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.support;

import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;

public class PseudoArgs<OPTS> {
    private final OPTS options;
    private final String scopeName;
    private final String collectionName;

    public PseudoArgs(String scopeName, String collectionName, OPTS options) {
        this.options = options;
        this.scopeName = scopeName;
        this.collectionName = collectionName;
    }

    public PseudoArgs(ReactiveCouchbaseTemplate template, String scope, String collection, OPTS options) {
        String scopeForQuery = scope;
        String collectionForQuery = collection;
        OPTS optionsForQuery = options;
        scopeForQuery = scopeForQuery != null ? scopeForQuery : this.getThreadLocalScopeName(template);
        collectionForQuery = collectionForQuery != null ? collectionForQuery : this.getThreadLocalCollectionName(template);
        OPTS OPTS = optionsForQuery = optionsForQuery != null ? optionsForQuery : this.getThreadLocalOptions(template);
        if (collectionForQuery != null && scopeForQuery == null) {
            scopeForQuery = template.getCouchbaseClientFactory().getScope().name();
        }
        if ((scopeForQuery == null || "_default".equals(scopeForQuery)) && (collectionForQuery == null || "_default".equals(collectionForQuery))) {
            scopeForQuery = null;
            collectionForQuery = null;
        }
        this.scopeName = scopeForQuery;
        this.collectionName = collectionForQuery;
        this.options = optionsForQuery;
    }

    public OPTS getOptions() {
        return this.options;
    }

    public String getScope() {
        return this.scopeName;
    }

    public String getCollection() {
        return this.collectionName;
    }

    private OPTS getThreadLocalOptions(ReactiveCouchbaseTemplate template) {
        return template.getPseudoArgs() == null ? null : (OPTS)template.getPseudoArgs().getOptions();
    }

    private String getThreadLocalScopeName(ReactiveCouchbaseTemplate template) {
        return template.getPseudoArgs() == null ? null : template.getPseudoArgs().getScope();
    }

    private String getThreadLocalCollectionName(ReactiveCouchbaseTemplate template) {
        return template.getPseudoArgs() == null ? null : template.getPseudoArgs().getCollection();
    }
}

