/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.reactive;

import java.net.InetSocketAddress;
import java.util.Collections;
import org.springframework.data.elasticsearch.client.ElasticsearchHost;
import org.springframework.data.elasticsearch.client.NoReachableHostException;
import org.springframework.data.elasticsearch.client.reactive.HostProvider;
import org.springframework.data.elasticsearch.client.reactive.WebClientProvider;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

class SingleNodeHostProvider
implements HostProvider {
    private final WebClientProvider clientProvider;
    private final InetSocketAddress endpoint;
    private volatile ElasticsearchHost state;

    SingleNodeHostProvider(WebClientProvider clientProvider, InetSocketAddress endpoint) {
        this.clientProvider = clientProvider;
        this.endpoint = endpoint;
        this.state = new ElasticsearchHost(this.endpoint, ElasticsearchHost.State.UNKNOWN);
    }

    @Override
    public Mono<HostProvider.ClusterInformation> clusterInfo() {
        return this.createWebClient(this.endpoint).head().uri("/", new Object[0]).exchange().flatMap(it -> {
            this.state = it.statusCode().isError() ? ElasticsearchHost.offline(this.endpoint) : ElasticsearchHost.online(this.endpoint);
            return Mono.just((Object)this.state);
        }).onErrorResume(throwable -> {
            this.state = ElasticsearchHost.offline(this.endpoint);
            this.clientProvider.getErrorListener().accept((Throwable)throwable);
            return Mono.just((Object)this.state);
        }).flatMap(it -> Mono.just((Object)new HostProvider.ClusterInformation(Collections.singleton(it))));
    }

    @Override
    public WebClient createWebClient(InetSocketAddress endpoint) {
        return this.clientProvider.get(endpoint);
    }

    @Override
    public Mono<InetSocketAddress> lookupActiveHost(HostProvider.Verification verification) {
        if (HostProvider.Verification.LAZY.equals((Object)verification) && this.state.isOnline()) {
            return Mono.just((Object)this.endpoint);
        }
        return this.clusterInfo().flatMap(it -> {
            ElasticsearchHost host = it.getNodes().iterator().next();
            if (host.isOnline()) {
                return Mono.just((Object)host.getEndpoint());
            }
            return Mono.error(() -> new NoReachableHostException(Collections.singleton(host)));
        });
    }

    ElasticsearchHost getCachedHostState() {
        return this.state;
    }
}

