/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config.namespace;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.hadoop.config.namespace.ScriptParser;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class ScriptTaskletParser
extends AbstractSimpleBeanDefinitionParser {
    ScriptTaskletParser() {
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        String scope = element.getAttribute("scope");
        if (StringUtils.hasText((String)scope)) {
            builder.setScope(scope);
        }
        String attribute = element.getAttribute("script-ref");
        Element nestedScript = DomUtils.getChildElementByTagName((Element)element, (String)"script");
        if (StringUtils.hasText((String)attribute) && nestedScript != null) {
            parserContext.getReaderContext().error("Cannot use define both 'script-ref' and a nested script; use only one", (Object)element);
        }
        RuntimeBeanReference script = null;
        if (nestedScript != null) {
            BeanDefinition nested = new ScriptParser().parse(nestedScript, parserContext);
            if (StringUtils.hasText((String)scope)) {
                nested.setScope(scope);
            }
            script = nested;
        } else {
            script = new RuntimeBeanReference(attribute);
        }
        builder.addPropertyValue("scriptCallback", (Object)script);
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return false;
    }

    protected String getBeanClassName(Element element) {
        return "org.springframework.data.hadoop.batch.scripting.ScriptTasklet";
    }
}

