/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class StoredProcedureAttributes {
    static final String SYNTHETIC_OUTPUT_PARAMETER_NAME = "out";
    private final boolean namedStoredProcedure;
    private final String procedureName;
    private final List<String> outputParameterNames;
    private final List<Class<?>> outputParameterTypes;

    StoredProcedureAttributes(String procedureName, @Nullable String outputParameterName, Class<?> outputParameterType) {
        this(procedureName, Collections.singletonList(outputParameterName), Collections.singletonList(outputParameterType), false);
    }

    StoredProcedureAttributes(String procedureName, List<String> outputParameterNames, List<Class<?>> outputParameterTypes, boolean namedStoredProcedure) {
        Assert.notNull((Object)procedureName, (String)"ProcedureName must not be null!");
        Assert.notNull(outputParameterNames, (String)"OutputParameterNames must not be null!");
        Assert.notEmpty(outputParameterTypes, (String)"OutputParameterTypes must not be empty!");
        Assert.isTrue((outputParameterTypes.size() != 1 || outputParameterTypes.get(0) != null ? 1 : 0) != 0, (String)"OutputParameterTypes must not have size 1 with a null value");
        this.procedureName = procedureName;
        this.outputParameterNames = namedStoredProcedure ? outputParameterNames : this.completeOutputParameterNames(outputParameterNames);
        this.outputParameterTypes = outputParameterTypes;
        this.namedStoredProcedure = namedStoredProcedure;
    }

    private List<String> completeOutputParameterNames(List<String> outputParameterNames) {
        return IntStream.range(0, outputParameterNames.size()).mapToObj(i -> this.completeOutputParameterName(i, (String)outputParameterNames.get(i))).collect(Collectors.toList());
    }

    private String completeOutputParameterName(int i, String paramName) {
        return StringUtils.hasText((String)paramName) ? paramName : this.createSyntheticParameterName(i);
    }

    private String createSyntheticParameterName(int i) {
        return SYNTHETIC_OUTPUT_PARAMETER_NAME + (i == 0 ? "" : Integer.valueOf(i));
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public List<String> getOutputParameterNames() {
        return this.outputParameterNames;
    }

    public List<Class<?>> getOutputParameterTypes() {
        return this.outputParameterTypes;
    }

    public boolean isNamedStoredProcedure() {
        return this.namedStoredProcedure;
    }

    public boolean hasReturnValue() {
        return this.outputParameterTypes.size() != 1 || !Void.TYPE.equals(this.outputParameterTypes.get(0)) && !Void.class.equals(this.outputParameterTypes.get(0));
    }
}

