/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.query;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.ldap.repository.LdapEncode;
import org.springframework.data.ldap.repository.LdapEncoder;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;

public class LdapParameters
extends Parameters<LdapParameters, LdapParameter> {
    private final TypeInformation<?> domainType;

    public LdapParameters(ParametersSource parametersSource) {
        super(parametersSource, methodParameter -> new LdapParameter((MethodParameter)methodParameter, (TypeInformation<?>)parametersSource.getDomainTypeInformation()));
        this.domainType = parametersSource.getDomainTypeInformation();
    }

    private LdapParameters(List<LdapParameter> parameters, TypeInformation<?> domainType) {
        super(parameters);
        this.domainType = domainType;
    }

    protected LdapParameters createFrom(List<LdapParameter> parameters) {
        return new LdapParameters(parameters, this.domainType);
    }

    protected static class LdapParameter
    extends Parameter {
        private final @Nullable LdapEncoder ldapEncoder;
        private final MethodParameter parameter;

        LdapParameter(MethodParameter parameter, TypeInformation<?> domainType) {
            super(parameter, domainType);
            this.parameter = parameter;
            LdapEncode encode = (LdapEncode)parameter.getParameterAnnotation(LdapEncode.class);
            this.ldapEncoder = encode != null ? (LdapEncoder)BeanUtils.instantiateClass(encode.value()) : null;
        }

        public boolean hasLdapEncoder() {
            return this.ldapEncoder != null;
        }

        public LdapEncoder getLdapEncoder() {
            if (this.ldapEncoder == null) {
                throw new IllegalStateException("No LdapEncoder found for parameter " + String.valueOf(this.parameter));
            }
            return this.ldapEncoder;
        }
    }
}

