/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AggregationOptions {
    private static final String BATCH_SIZE = "batchSize";
    private static final String CURSOR = "cursor";
    private static final String EXPLAIN = "explain";
    private static final String ALLOW_DISK_USE = "allowDiskUse";
    private static final String COLLATION = "collation";
    private static final String COMMENT = "comment";
    private static final String MAX_TIME = "maxTimeMS";
    private static final String HINT = "hint";
    private final boolean allowDiskUse;
    private final boolean explain;
    private final Optional<Document> cursor;
    private final Optional<Collation> collation;
    private final Optional<String> comment;
    private final Optional<Document> hint;
    private Duration maxTime = Duration.ZERO;
    private ResultOptions resultOptions = ResultOptions.READ;
    private DomainTypeMapping domainTypeMapping = DomainTypeMapping.RELAXED;

    public AggregationOptions(boolean allowDiskUse, boolean explain, @Nullable Document cursor) {
        this(allowDiskUse, explain, cursor, null);
    }

    public AggregationOptions(boolean allowDiskUse, boolean explain, @Nullable Document cursor, @Nullable Collation collation) {
        this(allowDiskUse, explain, cursor, collation, null, null);
    }

    public AggregationOptions(boolean allowDiskUse, boolean explain, @Nullable Document cursor, @Nullable Collation collation, @Nullable String comment) {
        this(allowDiskUse, explain, cursor, collation, comment, null);
    }

    private AggregationOptions(boolean allowDiskUse, boolean explain, @Nullable Document cursor, @Nullable Collation collation, @Nullable String comment, @Nullable Document hint) {
        this.allowDiskUse = allowDiskUse;
        this.explain = explain;
        this.cursor = Optional.ofNullable(cursor);
        this.collation = Optional.ofNullable(collation);
        this.comment = Optional.ofNullable(comment);
        this.hint = Optional.ofNullable(hint);
    }

    public AggregationOptions(boolean allowDiskUse, boolean explain, int cursorBatchSize) {
        this(allowDiskUse, explain, AggregationOptions.createCursor(cursorBatchSize), null);
    }

    public static AggregationOptions fromDocument(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        boolean allowDiskUse = document.getBoolean((Object)ALLOW_DISK_USE, false);
        boolean explain = document.getBoolean((Object)EXPLAIN, false);
        Document cursor = (Document)document.get((Object)CURSOR, Document.class);
        Collation collation = document.containsKey((Object)COLLATION) ? Collation.from((Document)document.get((Object)COLLATION, Document.class)) : null;
        String comment = document.getString((Object)COMMENT);
        Document hint = (Document)document.get((Object)HINT, Document.class);
        AggregationOptions options = new AggregationOptions(allowDiskUse, explain, cursor, collation, comment, hint);
        if (document.containsKey((Object)MAX_TIME)) {
            options.maxTime = Duration.ofMillis(document.getLong((Object)MAX_TIME));
        }
        return options;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isAllowDiskUse() {
        return this.allowDiskUse;
    }

    public boolean isExplain() {
        return this.explain;
    }

    @Nullable
    public Integer getCursorBatchSize() {
        if (this.cursor.filter(val -> val.containsKey((Object)BATCH_SIZE)).isPresent()) {
            return (Integer)this.cursor.get().get((Object)BATCH_SIZE, Integer.class);
        }
        return null;
    }

    public Optional<Document> getCursor() {
        return this.cursor;
    }

    public Optional<Collation> getCollation() {
        return this.collation;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public Optional<Document> getHint() {
        return this.hint;
    }

    public Duration getMaxTime() {
        return this.maxTime;
    }

    public boolean isSkipResults() {
        return ResultOptions.SKIP.equals((Object)this.resultOptions);
    }

    public DomainTypeMapping getDomainTypeMapping() {
        return this.domainTypeMapping;
    }

    Document applyAndReturnPotentiallyChangedCommand(Document command) {
        Document result = new Document((Map)command);
        if (this.allowDiskUse && !result.containsKey((Object)ALLOW_DISK_USE)) {
            result.put(ALLOW_DISK_USE, (Object)this.allowDiskUse);
        }
        if (this.explain && !result.containsKey((Object)EXPLAIN)) {
            result.put(EXPLAIN, (Object)this.explain);
        }
        if (result.containsKey((Object)HINT)) {
            this.hint.ifPresent(val -> result.append(HINT, val));
        }
        if (!result.containsKey((Object)CURSOR)) {
            this.cursor.ifPresent(val -> result.put(CURSOR, val));
        }
        if (!result.containsKey((Object)COLLATION)) {
            this.collation.map(Collation::toDocument).ifPresent(val -> result.append(COLLATION, val));
        }
        if (this.hasExecutionTimeLimit() && !result.containsKey((Object)MAX_TIME)) {
            result.append(MAX_TIME, (Object)this.maxTime.toMillis());
        }
        return result;
    }

    public Document toDocument() {
        Document document = new Document();
        document.put(ALLOW_DISK_USE, (Object)this.allowDiskUse);
        document.put(EXPLAIN, (Object)this.explain);
        this.cursor.ifPresent(val -> document.put(CURSOR, val));
        this.collation.ifPresent(val -> document.append(COLLATION, (Object)val.toDocument()));
        this.comment.ifPresent(val -> document.append(COMMENT, val));
        this.hint.ifPresent(val -> document.append(HINT, val));
        if (this.hasExecutionTimeLimit()) {
            document.append(MAX_TIME, (Object)this.maxTime.toMillis());
        }
        return document;
    }

    public boolean hasExecutionTimeLimit() {
        return !this.maxTime.isZero() && !this.maxTime.isNegative();
    }

    public String toString() {
        return this.toDocument().toJson();
    }

    static Document createCursor(int cursorBatchSize) {
        return new Document(BATCH_SIZE, (Object)cursorBatchSize);
    }

    private static enum ResultOptions {
        SKIP,
        READ;

    }

    public static enum DomainTypeMapping {
        STRICT,
        RELAXED,
        NONE;

    }

    public static class Builder {
        private boolean allowDiskUse;
        private boolean explain;
        @Nullable
        private Document cursor;
        @Nullable
        private Collation collation;
        @Nullable
        private String comment;
        @Nullable
        private Document hint;
        @Nullable
        private Duration maxTime;
        @Nullable
        private ResultOptions resultOptions;
        @Nullable
        private DomainTypeMapping domainTypeMapping;

        public Builder allowDiskUse(boolean allowDiskUse) {
            this.allowDiskUse = allowDiskUse;
            return this;
        }

        public Builder explain(boolean explain) {
            this.explain = explain;
            return this;
        }

        public Builder cursor(Document cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursorBatchSize(int batchSize) {
            this.cursor = AggregationOptions.createCursor(batchSize);
            return this;
        }

        public Builder collation(@Nullable Collation collation) {
            this.collation = collation;
            return this;
        }

        public Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public Builder hint(@Nullable Document hint) {
            this.hint = hint;
            return this;
        }

        public Builder maxTime(@Nullable Duration maxTime) {
            this.maxTime = maxTime;
            return this;
        }

        public Builder skipOutput() {
            this.resultOptions = ResultOptions.SKIP;
            return this;
        }

        public Builder strictMapping() {
            this.domainTypeMapping = DomainTypeMapping.STRICT;
            return this;
        }

        public Builder relaxedMapping() {
            this.domainTypeMapping = DomainTypeMapping.RELAXED;
            return this;
        }

        public Builder noMapping() {
            this.domainTypeMapping = DomainTypeMapping.NONE;
            return this;
        }

        public AggregationOptions build() {
            AggregationOptions options = new AggregationOptions(this.allowDiskUse, this.explain, this.cursor, this.collation, this.comment, this.hint);
            if (this.maxTime != null) {
                options.maxTime = this.maxTime;
            }
            if (this.resultOptions != null) {
                options.resultOptions = this.resultOptions;
            }
            if (this.domainTypeMapping != null) {
                options.domainTypeMapping = this.domainTypeMapping;
            }
            return options;
        }
    }
}

