/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.GeoJsonLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiPolygon;
import org.springframework.data.mongodb.core.geo.GeoJsonPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonPolygon;

class GeoJsonSerializersModule
extends SimpleModule {
    private static final long serialVersionUID = 1340494654898895610L;

    GeoJsonSerializersModule() {
        GeoJsonSerializersModule.registerSerializersIn(this);
    }

    static void registerSerializersIn(SimpleModule module) {
        module.addSerializer(GeoJsonPoint.class, (JsonSerializer)new GeoJsonPointSerializer());
        module.addSerializer(GeoJsonMultiPoint.class, (JsonSerializer)new GeoJsonMultiPointSerializer());
        module.addSerializer(GeoJsonLineString.class, (JsonSerializer)new GeoJsonLineStringSerializer());
        module.addSerializer(GeoJsonMultiLineString.class, (JsonSerializer)new GeoJsonMultiLineStringSerializer());
        module.addSerializer(GeoJsonPolygon.class, (JsonSerializer)new GeoJsonPolygonSerializer());
        module.addSerializer(GeoJsonMultiPolygon.class, (JsonSerializer)new GeoJsonMultiPolygonSerializer());
    }

    static class GeoJsonPointSerializer
    extends GeoJsonSerializer<GeoJsonPoint> {
        GeoJsonPointSerializer() {
        }

        @Override
        protected void doSerialize(GeoJsonPoint value, JsonGenerator jsonGenerator) throws IOException {
            this.writeRawCoordinates(value, jsonGenerator);
        }
    }

    static class GeoJsonMultiPointSerializer
    extends GeoJsonSerializer<GeoJsonMultiPoint> {
        GeoJsonMultiPointSerializer() {
        }

        @Override
        protected void doSerialize(GeoJsonMultiPoint value, JsonGenerator jsonGenerator) throws IOException {
            this.writeRawLine(value.getCoordinates(), jsonGenerator);
        }
    }

    static class GeoJsonLineStringSerializer
    extends GeoJsonSerializer<GeoJsonLineString> {
        GeoJsonLineStringSerializer() {
        }

        @Override
        protected void doSerialize(GeoJsonLineString value, JsonGenerator jsonGenerator) throws IOException {
            this.writeRawLine(value.getCoordinates(), jsonGenerator);
        }
    }

    static class GeoJsonMultiLineStringSerializer
    extends GeoJsonSerializer<GeoJsonMultiLineString> {
        GeoJsonMultiLineStringSerializer() {
        }

        @Override
        protected void doSerialize(GeoJsonMultiLineString value, JsonGenerator jsonGenerator) throws IOException {
            for (GeoJsonLineString lineString : value.getCoordinates()) {
                this.writeLine(lineString.getCoordinates(), jsonGenerator);
            }
        }
    }

    static class GeoJsonPolygonSerializer
    extends GeoJsonSerializer<GeoJsonPolygon> {
        GeoJsonPolygonSerializer() {
        }

        @Override
        protected void doSerialize(GeoJsonPolygon value, JsonGenerator jsonGenerator) throws IOException {
            for (GeoJsonLineString lineString : value.getCoordinates()) {
                this.writeLine(lineString.getCoordinates(), jsonGenerator);
            }
        }
    }

    static class GeoJsonMultiPolygonSerializer
    extends GeoJsonSerializer<GeoJsonMultiPolygon> {
        GeoJsonMultiPolygonSerializer() {
        }

        @Override
        protected void doSerialize(GeoJsonMultiPolygon value, JsonGenerator jsonGenerator) throws IOException {
            for (GeoJsonPolygon polygon : value.getCoordinates()) {
                jsonGenerator.writeStartArray();
                for (GeoJsonLineString lineString : polygon.getCoordinates()) {
                    this.writeLine(lineString.getCoordinates(), jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
        }
    }

    private static abstract class GeoJsonSerializer<T extends GeoJson<? extends Iterable>>
    extends JsonSerializer<T> {
        private GeoJsonSerializer() {
        }

        public void serialize(T shape, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("type", shape.getType());
            jsonGenerator.writeArrayFieldStart("coordinates");
            this.doSerialize(shape, jsonGenerator);
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
        }

        protected abstract void doSerialize(T var1, JsonGenerator var2) throws IOException;

        protected void writePoint(Point point, JsonGenerator jsonGenerator) throws IOException {
            jsonGenerator.writeStartArray();
            this.writeRawCoordinates(point, jsonGenerator);
            jsonGenerator.writeEndArray();
        }

        protected void writeRawCoordinates(Point point, JsonGenerator jsonGenerator) throws IOException {
            jsonGenerator.writeNumber(point.getX());
            jsonGenerator.writeNumber(point.getY());
        }

        protected void writeLine(Iterable<Point> points, JsonGenerator jsonGenerator) throws IOException {
            jsonGenerator.writeStartArray();
            this.writeRawLine(points, jsonGenerator);
            jsonGenerator.writeEndArray();
        }

        protected void writeRawLine(Iterable<Point> points, JsonGenerator jsonGenerator) throws IOException {
            for (Point point : points) {
                this.writePoint(point, jsonGenerator);
            }
        }
    }
}

