/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.schema;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bson.BsonNull;
import org.bson.Document;
import org.springframework.data.domain.Range;
import org.springframework.data.mongodb.core.schema.QueryCharacteristic;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;

public class QueryCharacteristics
implements Streamable<QueryCharacteristic> {
    private static final QueryCharacteristics NONE = new QueryCharacteristics(Collections.emptyList());
    private final List<QueryCharacteristic> characteristics;

    QueryCharacteristics(List<QueryCharacteristic> characteristics) {
        this.characteristics = characteristics;
    }

    public static QueryCharacteristics none() {
        return NONE;
    }

    public static QueryCharacteristics of(List<QueryCharacteristic> characteristics) {
        return new QueryCharacteristics(List.copyOf(characteristics));
    }

    public static QueryCharacteristics of(QueryCharacteristic ... characteristics) {
        return new QueryCharacteristics(Arrays.asList(characteristics));
    }

    public List<QueryCharacteristic> getCharacteristics() {
        return this.characteristics;
    }

    public Iterator<QueryCharacteristic> iterator() {
        return this.characteristics.iterator();
    }

    public static <T> RangeQuery<T> range() {
        return new RangeQuery();
    }

    public static <T> EqualityQuery<T> equality() {
        return new EqualityQuery(null);
    }

    public static class RangeQuery<T>
    implements QueryCharacteristic {
        @Nullable
        private final Range<T> valueRange;
        @Nullable
        private final Integer trimFactor;
        @Nullable
        private final Long sparsity;
        @Nullable
        private final Long precision;
        @Nullable
        private final Long contention;

        private RangeQuery() {
            this(Range.unbounded(), null, null, null, null);
        }

        public RangeQuery(@Nullable Range<T> valueRange, @Nullable Integer trimFactor, @Nullable Long sparsity, @Nullable Long precision, @Nullable Long contention) {
            this.valueRange = valueRange;
            this.trimFactor = trimFactor;
            this.sparsity = sparsity;
            this.precision = precision;
            this.contention = contention;
        }

        public RangeQuery<T> min(T lower) {
            Range range = Range.of((Range.Bound)Range.Bound.inclusive(lower), (Range.Bound)(this.valueRange != null ? this.valueRange.getUpperBound() : Range.Bound.unbounded()));
            return new RangeQuery<T>(range, this.trimFactor, this.sparsity, this.precision, this.contention);
        }

        public RangeQuery<T> max(T upper) {
            Range range = Range.of((Range.Bound)(this.valueRange != null ? this.valueRange.getLowerBound() : Range.Bound.unbounded()), (Range.Bound)Range.Bound.inclusive(upper));
            return new RangeQuery<T>(range, this.trimFactor, this.sparsity, this.precision, this.contention);
        }

        public RangeQuery<T> trimFactor(int trimFactor) {
            return new RangeQuery<T>(this.valueRange, trimFactor, this.sparsity, this.precision, this.contention);
        }

        public RangeQuery<T> sparsity(long sparsity) {
            return new RangeQuery<T>(this.valueRange, this.trimFactor, sparsity, this.precision, this.contention);
        }

        public RangeQuery<T> contention(long contention) {
            return new RangeQuery<T>(this.valueRange, this.trimFactor, this.sparsity, this.precision, contention);
        }

        public RangeQuery<T> precision(long precision) {
            return new RangeQuery<T>(this.valueRange, this.trimFactor, this.sparsity, precision, this.contention);
        }

        @Override
        public String queryType() {
            return "range";
        }

        @Override
        public Document toDocument() {
            Document target = QueryCharacteristic.super.toDocument();
            if (this.contention != null) {
                target.append("contention", (Object)this.contention);
            }
            if (this.trimFactor != null) {
                target.append("trimFactor", (Object)this.trimFactor);
            }
            if (this.valueRange != null) {
                target.append("min", (Object)this.valueRange.getLowerBound().getValue().orElse(BsonNull.VALUE)).append("max", (Object)this.valueRange.getUpperBound().getValue().orElse(BsonNull.VALUE));
            }
            if (this.precision != null) {
                target.append("precision", (Object)this.precision);
            }
            if (this.sparsity != null) {
                target.append("sparsity", (Object)this.sparsity);
            }
            return target;
        }
    }

    public static class EqualityQuery<T>
    implements QueryCharacteristic {
        @Nullable
        private final Long contention;

        public EqualityQuery(@Nullable Long contention) {
            this.contention = contention;
        }

        public EqualityQuery<T> contention(long contention) {
            return new EqualityQuery<T>(contention);
        }

        @Override
        public String queryType() {
            return "equality";
        }

        @Override
        public Document toDocument() {
            return QueryCharacteristic.super.toDocument().append("contention", (Object)this.contention);
        }
    }
}

