/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;
import org.springframework.lang.Nullable;

class ColumnVisitor
extends TypedSubtreeVisitor<Column> {
    private final RenderContext context;
    private final RenderTarget target;
    private final boolean considerTablePrefix;
    @Nullable
    private String tableName;

    ColumnVisitor(RenderContext context, boolean considerTablePrefix, RenderTarget target) {
        this.context = context;
        this.target = target;
        this.considerTablePrefix = considerTablePrefix;
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(Column segment) {
        String column = this.context.getNamingStrategy().getName(segment);
        StringBuilder builder = new StringBuilder(this.tableName != null ? this.tableName.length() + column.length() : column.length());
        if (this.considerTablePrefix && this.tableName != null) {
            builder.append(this.tableName);
        }
        builder.append(column);
        this.target.onRendered(builder);
        return super.leaveMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (segment instanceof Table) {
            this.tableName = this.context.getNamingStrategy().getReferenceName((Table)segment) + '.';
        }
        return super.leaveNested(segment);
    }
}

